/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.profiler.context.CallStack;
import com.navercorp.pinpoint.profiler.context.CloseListener;
import com.navercorp.pinpoint.profiler.context.DefaultTrace;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.recorder.WrappedSpanEventRecorder;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import java.util.Objects;

public class AsyncDefaultTrace
extends DefaultTrace {
    private final AsyncState asyncState;

    public AsyncDefaultTrace(Span span, CallStack<SpanEvent> callStack, Storage storage, SpanRecorder spanRecorder, WrappedSpanEventRecorder wrappedSpanEventRecorder, AsyncState asyncState) {
        super(span, callStack, storage, spanRecorder, wrappedSpanEventRecorder, CloseListener.EMPTY);
        this.asyncState = Objects.requireNonNull(asyncState, "asyncState");
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            this.logger.debug("Already closed");
            return;
        }
        if (this.asyncState.await()) {
            super.flush();
            if (this.isDebug) {
                this.logger.debug("Await trace={}, asyncState={}", (Object)this, (Object)this.asyncState);
            }
        } else {
            super.close();
            if (this.isDebug) {
                this.logger.debug("Close trace={}. asyncState={}", (Object)this, (Object)this.asyncState);
            }
        }
    }

    @Override
    public String toString() {
        return "AsyncDefaultTrace{asyncState=" + this.asyncState + "} " + super.toString();
    }
}

