/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.profiler.context.CloseListener;
import com.navercorp.pinpoint.profiler.context.id.LocalTraceRoot;
import com.navercorp.pinpoint.profiler.context.id.Shared;
import com.navercorp.pinpoint.profiler.context.scope.DefaultTraceScopePool;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DisableTrace
implements Trace {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    public static final String UNSUPPORTED_OPERATION = "disable trace";
    public static final long DISABLE_TRACE_OBJECT_ID = -1L;
    private final LocalTraceRoot traceRoot;
    private final SpanRecorder spanRecorder;
    private DefaultTraceScopePool scopePool;
    private final CloseListener closeListener;
    private int depth;
    private SpanEventRecorder spanEventRecorder;
    private boolean closed = false;

    public DisableTrace(LocalTraceRoot traceRoot, SpanRecorder spanRecorder, SpanEventRecorder spanEventRecorder, CloseListener closeListener) {
        this.traceRoot = Objects.requireNonNull(traceRoot, "traceRoot");
        this.spanRecorder = Objects.requireNonNull(spanRecorder, "spanRecorder");
        this.spanEventRecorder = Objects.requireNonNull(spanEventRecorder, "spanEventRecorder");
        this.closeListener = Objects.requireNonNull(closeListener, "closeListener");
        this.setCurrentThread();
    }

    private void setCurrentThread() {
        long threadId = Thread.currentThread().getId();
        this.getShared().setThreadId(threadId);
    }

    public long getId() {
        return this.traceRoot.getLocalTransactionId();
    }

    public long getStartTime() {
        return this.traceRoot.getTraceStartTime();
    }

    public SpanEventRecorder traceBlockBegin() {
        return this.traceBlockBegin(-1);
    }

    public SpanEventRecorder traceBlockBegin(int stackId) {
        this.push();
        return this.spanEventRecorder;
    }

    public void traceBlockEnd() {
        this.traceBlockBegin(-1);
    }

    public void traceBlockEnd(int stackId) {
        this.pop();
    }

    private int push() {
        return this.depth++;
    }

    private void pop() {
        --this.depth;
    }

    public TraceId getTraceId() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    public boolean canSampled() {
        return false;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isAsync() {
        return false;
    }

    public boolean isRootStack() {
        return this.depth == 0;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (this.closed) {
            this.logger.debug("Already closed");
            return;
        }
        this.closed = true;
        long purgeTime = System.currentTimeMillis();
        this.closeListener.close(purgeTime);
    }

    protected void flush() {
        this.closed = true;
    }

    private Shared getShared() {
        return this.traceRoot.getShared();
    }

    public int getCallStackFrameId() {
        return -1;
    }

    public SpanRecorder getSpanRecorder() {
        return this.spanRecorder;
    }

    public SpanEventRecorder currentSpanEventRecorder() {
        return this.spanEventRecorder;
    }

    public TraceScope getScope(String name) {
        if (this.scopePool == null) {
            return null;
        }
        return this.scopePool.get(name);
    }

    public TraceScope addScope(String name) {
        if (this.scopePool == null) {
            this.scopePool = new DefaultTraceScopePool();
        }
        return this.scopePool.add(name);
    }
}

