/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc.mapper;

import com.navercorp.pinpoint.grpc.trace.PCustomMetric;
import com.navercorp.pinpoint.grpc.trace.PCustomMetricMessage;
import com.navercorp.pinpoint.grpc.trace.PDoubleValue;
import com.navercorp.pinpoint.grpc.trace.PDouleGaugeMetric;
import com.navercorp.pinpoint.grpc.trace.PIntCountMetric;
import com.navercorp.pinpoint.grpc.trace.PIntGaugeMetric;
import com.navercorp.pinpoint.grpc.trace.PIntValue;
import com.navercorp.pinpoint.grpc.trace.PLongCountMetric;
import com.navercorp.pinpoint.grpc.trace.PLongGaugeMetric;
import com.navercorp.pinpoint.grpc.trace.PLongValue;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentCustomMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentCustomMetricSnapshotBatch;
import com.navercorp.pinpoint.profiler.monitor.metric.custom.CustomMetricVo;
import com.navercorp.pinpoint.profiler.monitor.metric.custom.DoubleGaugeMetricVo;
import com.navercorp.pinpoint.profiler.monitor.metric.custom.IntCountMetricVo;
import com.navercorp.pinpoint.profiler.monitor.metric.custom.IntGaugeMetricVo;
import com.navercorp.pinpoint.profiler.monitor.metric.custom.LongCountMetricVo;
import com.navercorp.pinpoint.profiler.monitor.metric.custom.LongGaugeMetricVo;
import java.util.HashSet;
import java.util.List;
import org.mapstruct.AfterMapping;
import org.mapstruct.CollectionMappingStrategy;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.NullValueCheckStrategy;
import org.mapstruct.NullValuePropertyMappingStrategy;

@Mapper(collectionMappingStrategy=CollectionMappingStrategy.ADDER_PREFERRED, nullValueCheckStrategy=NullValueCheckStrategy.ALWAYS, nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE, uses={})
public interface CustomMetricMapper {
    default public PCustomMetricMessage map(AgentCustomMetricSnapshotBatch message) {
        List<AgentCustomMetricSnapshot> agentCustomMetricSnapshotList = message.getAgentCustomMetricSnapshotList();
        HashSet<String> metricNameSet = new HashSet<String>();
        for (AgentCustomMetricSnapshot agentCustomMetricSnapshot : agentCustomMetricSnapshotList) {
            metricNameSet.addAll(agentCustomMetricSnapshot.getMetricNameSet());
        }
        PCustomMetricMessage.Builder builder = PCustomMetricMessage.newBuilder();
        for (AgentCustomMetricSnapshot agentCustomMetricSnapshot : agentCustomMetricSnapshotList) {
            builder.addTimestamp(agentCustomMetricSnapshot.getTimestamp());
            builder.addCollectInterval(agentCustomMetricSnapshot.getCollectInterval());
        }
        for (String metricName : metricNameSet) {
            PCustomMetric pCustomMetric = this.create(metricName, agentCustomMetricSnapshotList);
            if (pCustomMetric == null) continue;
            builder.addCustomMetrics(pCustomMetric);
        }
        return builder.build();
    }

    default public PCustomMetric create(String metricName, List<AgentCustomMetricSnapshot> agentCustomMetricSnapshotList) {
        int size = agentCustomMetricSnapshotList.size();
        CustomMetricVo representativeCustomMetricVo = null;
        CustomMetricVo[] customMetricVos = new CustomMetricVo[size];
        for (int i = 0; i < size; ++i) {
            CustomMetricVo customMetricVo;
            AgentCustomMetricSnapshot agentCustomMetricSnapshot = agentCustomMetricSnapshotList.get(i);
            customMetricVos[i] = customMetricVo = agentCustomMetricSnapshot.get(metricName);
            if (customMetricVo == null || representativeCustomMetricVo != null) continue;
            representativeCustomMetricVo = customMetricVo;
        }
        return this.map(metricName, representativeCustomMetricVo, customMetricVos);
    }

    default public PCustomMetric map(String metricName, CustomMetricVo representativeCustomMetricVo, CustomMetricVo[] customMetricVos) {
        if (representativeCustomMetricVo instanceof IntCountMetricVo) {
            return this.map(this.createIntCountMetric(metricName, customMetricVos));
        }
        if (representativeCustomMetricVo instanceof LongCountMetricVo) {
            return this.map(this.createLongCountMetric(metricName, customMetricVos));
        }
        if (representativeCustomMetricVo instanceof IntGaugeMetricVo) {
            return this.map(this.createIntGaugeMetric(metricName, customMetricVos));
        }
        if (representativeCustomMetricVo instanceof LongGaugeMetricVo) {
            return this.map(this.createLongGaugeMetric(metricName, customMetricVos));
        }
        if (representativeCustomMetricVo instanceof DoubleGaugeMetricVo) {
            return this.map(this.createDoubleGaugeMetric(metricName, customMetricVos));
        }
        return null;
    }

    @Mappings(value={@Mapping(source=".", target="intCountMetric"), @Mapping(target="longCountMetric", ignore=true), @Mapping(target="intGaugeMetric", ignore=true), @Mapping(target="longGaugeMetric", ignore=true), @Mapping(target="doubleGaugeMetric", ignore=true)})
    public PCustomMetric map(PIntCountMetric var1);

    @Mappings(value={@Mapping(source="metricName", target="name"), @Mapping(target="values", ignore=true)})
    public PIntCountMetric createIntCountMetric(String var1, CustomMetricVo[] var2);

    @Mappings(value={@Mapping(source=".", target="longCountMetric"), @Mapping(target="intCountMetric", ignore=true), @Mapping(target="intGaugeMetric", ignore=true), @Mapping(target="longGaugeMetric", ignore=true), @Mapping(target="doubleGaugeMetric", ignore=true)})
    public PCustomMetric map(PLongCountMetric var1);

    @Mappings(value={@Mapping(source="metricName", target="name"), @Mapping(target="values", ignore=true)})
    public PLongCountMetric createLongCountMetric(String var1, CustomMetricVo[] var2);

    @Mappings(value={@Mapping(source=".", target="intGaugeMetric"), @Mapping(target="intCountMetric", ignore=true), @Mapping(target="longCountMetric", ignore=true), @Mapping(target="longGaugeMetric", ignore=true), @Mapping(target="doubleGaugeMetric", ignore=true)})
    public PCustomMetric map(PIntGaugeMetric var1);

    @Mappings(value={@Mapping(source="metricName", target="name"), @Mapping(target="values", ignore=true)})
    public PIntGaugeMetric createIntGaugeMetric(String var1, CustomMetricVo[] var2);

    @Mappings(value={@Mapping(source=".", target="longGaugeMetric"), @Mapping(target="intCountMetric", ignore=true), @Mapping(target="longCountMetric", ignore=true), @Mapping(target="intGaugeMetric", ignore=true), @Mapping(target="doubleGaugeMetric", ignore=true)})
    public PCustomMetric map(PLongGaugeMetric var1);

    @Mappings(value={@Mapping(source="metricName", target="name"), @Mapping(target="values", ignore=true)})
    public PLongGaugeMetric createLongGaugeMetric(String var1, CustomMetricVo[] var2);

    @Mappings(value={@Mapping(source=".", target="doubleGaugeMetric"), @Mapping(target="intCountMetric", ignore=true), @Mapping(target="longCountMetric", ignore=true), @Mapping(target="intGaugeMetric", ignore=true), @Mapping(target="longGaugeMetric", ignore=true)})
    public PCustomMetric map(PDouleGaugeMetric var1);

    @Mappings(value={@Mapping(source="metricName", target="name"), @Mapping(target="values", ignore=true)})
    public PDouleGaugeMetric createDoubleGaugeMetric(String var1, CustomMetricVo[] var2);

    @AfterMapping
    default public void mapIntCountMetricVo(String metricName, CustomMetricVo[] customMetricVos, @MappingTarget PIntCountMetric.Builder builder) {
        Holder<Integer> prevValue = new Holder<Integer>(0);
        for (CustomMetricVo customMetricVo : customMetricVos) {
            builder.addValues(this.toIntCountValue(customMetricVo, prevValue));
        }
    }

    @AfterMapping
    default public void mapLongCountMetricVo(String metricName, CustomMetricVo[] customMetricVos, @MappingTarget PLongCountMetric.Builder builder) {
        Holder<Long> prevValue = new Holder<Long>(0L);
        for (CustomMetricVo customMetricVo : customMetricVos) {
            builder.addValues(this.toLongCountValue(customMetricVo, prevValue));
        }
    }

    @AfterMapping
    default public void mapIntGaugeMetricVo(String metricName, CustomMetricVo[] customMetricVos, @MappingTarget PIntGaugeMetric.Builder builder) {
        for (CustomMetricVo customMetricVo : customMetricVos) {
            builder.addValues(this.toIntGaugeValue(customMetricVo));
        }
    }

    @AfterMapping
    default public void mapLongGaugeMetricVo(String metricName, CustomMetricVo[] customMetricVos, @MappingTarget PLongGaugeMetric.Builder builder) {
        for (CustomMetricVo customMetricVo : customMetricVos) {
            builder.addValues(this.toLongGaugeValue(customMetricVo));
        }
    }

    @AfterMapping
    default public void mapDoubleGaugeMetricVo(String metricName, CustomMetricVo[] customMetricVos, @MappingTarget PDouleGaugeMetric.Builder builder) {
        for (CustomMetricVo customMetricVo : customMetricVos) {
            builder.addValues(this.toDoubleGaugeValue(customMetricVo));
        }
    }

    default public PIntValue toIntCountValue(CustomMetricVo customMetricVo, Holder<Integer> prev) {
        if (customMetricVo instanceof IntCountMetricVo) {
            int value = ((IntCountMetricVo)customMetricVo).getValue();
            PIntValue intValue = CustomMetricMapper.createIntValue(value - prev.getValue());
            prev.setValue(value);
            return intValue;
        }
        return CustomMetricMapper.createNotSetIntValue();
    }

    default public PLongValue toLongCountValue(CustomMetricVo customMetricVo, Holder<Long> prev) {
        if (customMetricVo instanceof LongCountMetricVo) {
            long value = ((LongCountMetricVo)customMetricVo).getValue();
            PLongValue longValue = CustomMetricMapper.createLongValue(value - prev.getValue());
            prev.setValue(value);
            return longValue;
        }
        return CustomMetricMapper.createNotSetLongValue();
    }

    default public PIntValue toIntGaugeValue(CustomMetricVo customMetricVo) {
        if (customMetricVo instanceof IntGaugeMetricVo) {
            int value = ((IntGaugeMetricVo)customMetricVo).getValue();
            return CustomMetricMapper.createIntValue(value);
        }
        return CustomMetricMapper.createNotSetIntValue();
    }

    default public PLongValue toLongGaugeValue(CustomMetricVo customMetricVo) {
        if (customMetricVo instanceof LongGaugeMetricVo) {
            long value = ((LongGaugeMetricVo)customMetricVo).getValue();
            return CustomMetricMapper.createLongValue(value);
        }
        return CustomMetricMapper.createNotSetLongValue();
    }

    default public PDoubleValue toDoubleGaugeValue(CustomMetricVo customMetricVo) {
        if (customMetricVo instanceof DoubleGaugeMetricVo) {
            double value = ((DoubleGaugeMetricVo)customMetricVo).getValue();
            return CustomMetricMapper.createDoubleValue(value);
        }
        return CustomMetricMapper.createNotSetDoubleValue();
    }

    public static PIntValue createIntValue(int value) {
        PIntValue.Builder builder = PIntValue.newBuilder();
        builder.setValue(value);
        return builder.build();
    }

    public static PIntValue createNotSetIntValue() {
        PIntValue.Builder builder = PIntValue.newBuilder();
        builder.setIsNotSet(true);
        return builder.build();
    }

    public static PLongValue createLongValue(long value) {
        PLongValue.Builder builder = PLongValue.newBuilder();
        builder.setValue(value);
        return builder.build();
    }

    public static PLongValue createNotSetLongValue() {
        PLongValue.Builder builder = PLongValue.newBuilder();
        builder.setIsNotSet(true);
        return builder.build();
    }

    public static PDoubleValue createDoubleValue(double value) {
        PDoubleValue.Builder builder = PDoubleValue.newBuilder();
        builder.setValue(value);
        return builder.build();
    }

    public static PDoubleValue createNotSetDoubleValue() {
        PDoubleValue.Builder builder = PDoubleValue.newBuilder();
        builder.setIsNotSet(true);
        return builder.build();
    }

    public static class Holder<V> {
        V value;

        public Holder(V value) {
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }
    }
}

