/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.classloading;

import com.navercorp.pinpoint.profiler.instrument.BootstrapPackage;
import com.navercorp.pinpoint.profiler.instrument.scanner.JarFileRepository;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BootstrapCore {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final BootstrapPackage bootstrapPackage;
    private final JarFileRepository bootstrapRepository;
    private final ClassLoader bootstrapClassLoader = Object.class.getClassLoader();

    public BootstrapCore(List<String> bootstrapJarPaths) {
        Objects.requireNonNull(bootstrapJarPaths, "bootstrapJarPaths");
        this.bootstrapRepository = new JarFileRepository(bootstrapJarPaths);
        this.bootstrapPackage = new BootstrapPackage();
    }

    public boolean isBootstrapPackage(String className) {
        return this.bootstrapPackage.isBootstrapPackage(className);
    }

    public boolean isBootstrapPackageByInternalName(String internalClassName) {
        return this.bootstrapPackage.isBootstrapPackageByInternalName(internalClassName);
    }

    public InputStream openStream(String internalClassName) {
        return this.bootstrapRepository.openStream(internalClassName);
    }

    public <T> Class<? extends T> loadClass(String className) {
        try {
            if (this.isDebug) {
                this.logger.debug("loadClass:{}", (Object)className);
            }
            return Class.forName(className, false, this.bootstrapClassLoader);
        }
        catch (ClassNotFoundException ex) {
            if (this.isDebug) {
                this.logger.debug("ClassNotFound {} cl:{}", (Object)ex.getMessage(), (Object)this.bootstrapClassLoader);
            }
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

