/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.interceptor;

import com.navercorp.pinpoint.bootstrap.interceptor.ApiIdAwareAroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor0;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor1;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor2;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor3;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor4;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor5;
import com.navercorp.pinpoint.bootstrap.interceptor.Interceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.StaticAroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.annotation.IgnoreMethod;
import com.navercorp.pinpoint.profiler.instrument.interceptor.CaptureType;
import com.navercorp.pinpoint.profiler.instrument.interceptor.DefaultInterceptorDefinition;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorDefinition;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InterceptorDefinitionFactory {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final List<TypeHandler> detectHandlers = this.register();

    public InterceptorDefinition createInterceptorDefinition(Class<?> interceptorClazz) {
        Objects.requireNonNull(interceptorClazz, "interceptorClazz");
        for (TypeHandler typeHandler : this.detectHandlers) {
            InterceptorDefinition interceptorDefinition = typeHandler.resolveType(interceptorClazz);
            if (interceptorDefinition == null) continue;
            return interceptorDefinition;
        }
        throw new RuntimeException("unsupported Interceptor Type. " + interceptorClazz.getName());
    }

    private List<TypeHandler> register() {
        ArrayList<TypeHandler> typeHandlerList = new ArrayList<TypeHandler>();
        this.addTypeHandler(typeHandlerList, AroundInterceptor.class, InterceptorType.ARRAY_ARGS);
        this.addTypeHandler(typeHandlerList, AroundInterceptor0.class, InterceptorType.BASIC);
        this.addTypeHandler(typeHandlerList, AroundInterceptor1.class, InterceptorType.BASIC);
        this.addTypeHandler(typeHandlerList, AroundInterceptor2.class, InterceptorType.BASIC);
        this.addTypeHandler(typeHandlerList, AroundInterceptor3.class, InterceptorType.BASIC);
        this.addTypeHandler(typeHandlerList, AroundInterceptor4.class, InterceptorType.BASIC);
        this.addTypeHandler(typeHandlerList, AroundInterceptor5.class, InterceptorType.BASIC);
        this.addTypeHandler(typeHandlerList, StaticAroundInterceptor.class, InterceptorType.STATIC);
        this.addTypeHandler(typeHandlerList, ApiIdAwareAroundInterceptor.class, InterceptorType.API_ID_AWARE);
        return typeHandlerList;
    }

    private void addTypeHandler(List<TypeHandler> typeHandlerList, Class<? extends Interceptor> interceptorClazz, InterceptorType arrayArgs) {
        TypeHandler typeHandler = this.createInterceptorTypeHandler(interceptorClazz, arrayArgs);
        typeHandlerList.add(typeHandler);
    }

    private TypeHandler createInterceptorTypeHandler(Class<? extends Interceptor> interceptorClazz, InterceptorType interceptorType) {
        Objects.requireNonNull(interceptorClazz, "interceptorClazz");
        Objects.requireNonNull(interceptorType, "interceptorType");
        Method[] declaredMethods = interceptorClazz.getDeclaredMethods();
        if (declaredMethods.length != 2) {
            throw new RuntimeException("invalid Type");
        }
        String before = "before";
        Method beforeMethod = this.findMethodByName(declaredMethods, "before");
        Class<?>[] beforeParamList = beforeMethod.getParameterTypes();
        String after = "after";
        Method afterMethod = this.findMethodByName(declaredMethods, "after");
        Class<?>[] afterParamList = afterMethod.getParameterTypes();
        return new TypeHandler(interceptorClazz, interceptorType, "before", beforeParamList, "after", afterParamList);
    }

    private Method findMethodByName(Method[] declaredMethods, String methodName) {
        Method findMethod = null;
        int count = 0;
        for (Method method : declaredMethods) {
            if (!method.getName().equals(methodName)) continue;
            ++count;
            findMethod = method;
        }
        if (findMethod == null) {
            throw new RuntimeException(methodName + " not found");
        }
        if (count > 1) {
            throw new RuntimeException("duplicated method exist. methodName:" + methodName);
        }
        return findMethod;
    }

    private class TypeHandler {
        private final Class<? extends Interceptor> interceptorClazz;
        private final InterceptorType interceptorType;
        private final String before;
        private final Class<?>[] beforeParamList;
        private final String after;
        private final Class<?>[] afterParamList;

        public TypeHandler(Class<? extends Interceptor> interceptorClazz, InterceptorType interceptorType, String before, Class<?>[] beforeParamList, String after, Class<?>[] afterParamList) {
            this.interceptorClazz = Objects.requireNonNull(interceptorClazz, "interceptorClazz");
            this.interceptorType = Objects.requireNonNull(interceptorType, "interceptorType");
            this.before = Objects.requireNonNull(before, "before");
            this.beforeParamList = Objects.requireNonNull(beforeParamList, "beforeParamList");
            this.after = Objects.requireNonNull(after, "after");
            this.afterParamList = Objects.requireNonNull(afterParamList, "afterParamList");
        }

        public InterceptorDefinition resolveType(Class<?> targetClazz) {
            if (!this.interceptorClazz.isAssignableFrom(targetClazz)) {
                return null;
            }
            Class<?> casting = targetClazz;
            return this.createInterceptorDefinition(casting);
        }

        private InterceptorDefinition createInterceptorDefinition(Class<? extends Interceptor> targetInterceptorClazz) {
            Method beforeMethod = this.searchMethod(targetInterceptorClazz, this.before, this.beforeParamList);
            if (beforeMethod == null) {
                throw new RuntimeException(this.before + " method not found. " + Arrays.toString(this.beforeParamList));
            }
            boolean beforeIgnoreMethod = beforeMethod.isAnnotationPresent(IgnoreMethod.class);
            Method afterMethod = this.searchMethod(targetInterceptorClazz, this.after, this.afterParamList);
            if (afterMethod == null) {
                throw new RuntimeException(this.after + " method not found. " + Arrays.toString(this.afterParamList));
            }
            boolean afterIgnoreMethod = afterMethod.isAnnotationPresent(IgnoreMethod.class);
            if (beforeIgnoreMethod && afterIgnoreMethod) {
                return new DefaultInterceptorDefinition(this.interceptorClazz, targetInterceptorClazz, this.interceptorType, CaptureType.NON, null, null);
            }
            if (beforeIgnoreMethod) {
                return new DefaultInterceptorDefinition(this.interceptorClazz, targetInterceptorClazz, this.interceptorType, CaptureType.AFTER, null, afterMethod);
            }
            if (afterIgnoreMethod) {
                return new DefaultInterceptorDefinition(this.interceptorClazz, targetInterceptorClazz, this.interceptorType, CaptureType.BEFORE, beforeMethod, null);
            }
            return new DefaultInterceptorDefinition(this.interceptorClazz, targetInterceptorClazz, this.interceptorType, CaptureType.AROUND, beforeMethod, afterMethod);
        }

        private Method searchMethod(Class<?> interceptorClazz, String searchMethodName, Class<?>[] searchMethodParameter) {
            Objects.requireNonNull(searchMethodName, "searchMethodName");
            try {
                return interceptorClazz.getMethod(searchMethodName, searchMethodParameter);
            }
            catch (NoSuchMethodException ex) {
                InterceptorDefinitionFactory.this.logger.debug(searchMethodName + " DeclaredMethod not found.");
                return null;
            }
        }
    }
}

