/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.transformer;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.navercorp.pinpoint.profiler.cache.CaffeineBuilder;
import com.navercorp.pinpoint.profiler.instrument.transformer.HierarchyCaches;

public class DefaultHierarchyCaches
implements HierarchyCaches {
    private static final int MAX = 64;
    private final LoadingCache<String, Hierarchy> caches;
    private final int cacheSize;
    private final int cacheEntrySize;

    public DefaultHierarchyCaches(int size, int entrySize) {
        if (size <= 0) {
            throw new IllegalArgumentException("negative cache size:" + size);
        }
        this.cacheSize = this.getCacheSize(size);
        this.cacheEntrySize = this.getCacheEntrySize(entrySize);
        this.caches = CaffeineBuilder.newBuilder().maximumSize((long)this.cacheSize).initialCapacity(this.cacheSize).build(this::loadEntry);
    }

    private Hierarchy loadEntry(String key) {
        return new Hierarchy();
    }

    private int getCacheEntrySize(int entrySize) {
        if (entrySize <= 0) {
            return this.cacheSize;
        }
        if (entrySize > 64) {
            return 64;
        }
        return entrySize;
    }

    private int getCacheSize(int size) {
        if (size > 64) {
            return 64;
        }
        return size;
    }

    @Override
    public boolean get(String key, String classInternalName) {
        Hierarchy hierarchy = (Hierarchy)this.caches.get((Object)key);
        if (hierarchy != null) {
            return hierarchy.cache.getIfPresent((Object)classInternalName) != null;
        }
        return false;
    }

    @Override
    public void put(String key, String classInternalName) {
        Hierarchy hierarchy = (Hierarchy)this.caches.get((Object)key);
        if (hierarchy != null) {
            hierarchy.cache.put((Object)classInternalName, (Object)Boolean.TRUE);
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public String toString() {
        String sb = "{stats=" + this.caches.stats() + "}";
        return sb;
    }

    class Hierarchy {
        Cache<String, Boolean> cache;

        public Hierarchy() {
            this.cache = Caffeine.newBuilder().maximumSize((long)DefaultHierarchyCaches.this.cacheEntrySize).initialCapacity(DefaultHierarchyCaches.this.cacheEntrySize).build();
        }

        public String toString() {
            return this.cache.asMap().keySet().toString();
        }
    }
}

