/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.metadata;

import com.navercorp.pinpoint.common.profiler.sql.DefaultSqlNormalizer;
import com.navercorp.pinpoint.common.profiler.sql.NormalizedSql;
import com.navercorp.pinpoint.common.profiler.sql.SqlNormalizer;
import com.navercorp.pinpoint.profiler.cache.Cache;
import com.navercorp.pinpoint.profiler.cache.Result;
import com.navercorp.pinpoint.profiler.metadata.CachingSqlNormalizer;
import com.navercorp.pinpoint.profiler.metadata.ParsingResultInternal;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultCachingSqlNormalizer<ID>
implements CachingSqlNormalizer<ParsingResultInternal<ID>> {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final Cache<String, Result<ID>> sqlCache;
    private final SqlNormalizer sqlNormalizer;

    public DefaultCachingSqlNormalizer(Cache<String, Result<ID>> sqlCache) {
        this.sqlCache = Objects.requireNonNull(sqlCache, "sqlCache");
        this.sqlNormalizer = new DefaultSqlNormalizer();
    }

    @Override
    public boolean normalizedSql(ParsingResultInternal<ID> parsingResult) {
        if (parsingResult == null) {
            return false;
        }
        if (parsingResult.getId() != null) {
            return false;
        }
        String originalSql = parsingResult.getOriginalSql();
        NormalizedSql normalizedSql = this.sqlNormalizer.normalizeSql(originalSql);
        Result<ID> cachingResult = this.sqlCache.put(normalizedSql.getNormalizedSql());
        boolean success = parsingResult.setId(cachingResult.getId());
        if (!success && this.logger.isWarnEnabled()) {
            this.logger.warn("invalid state. setSqlId fail setId:{}, ParsingResultInternal:{}", cachingResult.getId(), parsingResult);
        }
        parsingResult.setSql(normalizedSql.getNormalizedSql());
        parsingResult.setOutput(normalizedSql.getParseParameter());
        return cachingResult.isNewValue();
    }
}

