/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.collector;

import com.google.inject.Inject;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHistogram;
import com.navercorp.pinpoint.profiler.context.module.AgentId;
import com.navercorp.pinpoint.profiler.context.module.AgentStartTime;
import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.AgentStatMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.JvmGcMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.buffer.BufferMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuLoadMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSourceMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.deadlock.DeadlockMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.filedescriptor.FileDescriptorMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.loadedclass.LoadedClassMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.response.ResponseTimeValue;
import com.navercorp.pinpoint.profiler.monitor.metric.totalthread.TotalThreadMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.transaction.TransactionMetricSnapshot;
import java.util.Objects;

public class AgentStatCollector
implements AgentStatMetricCollector<AgentStatMetricSnapshot> {
    private final String agentId;
    private final long agentStartTimestamp;
    private final AgentStatMetricCollector<JvmGcMetricSnapshot> jvmGcMetricCollector;
    private final AgentStatMetricCollector<CpuLoadMetricSnapshot> cpuLoadMetricCollector;
    private final AgentStatMetricCollector<TransactionMetricSnapshot> transactionMetricCollector;
    private final AgentStatMetricCollector<ActiveTraceHistogram> activeTraceMetricCollector;
    private final AgentStatMetricCollector<DataSourceMetricSnapshot> dataSourceMetricCollector;
    private final AgentStatMetricCollector<ResponseTimeValue> responseTimeMetricCollector;
    private final AgentStatMetricCollector<DeadlockMetricSnapshot> deadlockMetricCollector;
    private final AgentStatMetricCollector<FileDescriptorMetricSnapshot> fileDescriptorMetricCollector;
    private final AgentStatMetricCollector<BufferMetricSnapshot> bufferMetricCollector;
    private final AgentStatMetricCollector<TotalThreadMetricSnapshot> totalThreadMetricCollector;
    private final AgentStatMetricCollector<LoadedClassMetricSnapshot> loadedClassMetricCollector;

    @Inject
    public AgentStatCollector(@AgentId String agentId, @AgentStartTime long agentStartTimestamp, AgentStatMetricCollector<JvmGcMetricSnapshot> jvmGcMetricCollector, AgentStatMetricCollector<CpuLoadMetricSnapshot> cpuLoadMetricCollector, AgentStatMetricCollector<TransactionMetricSnapshot> transactionMetricCollector, AgentStatMetricCollector<ActiveTraceHistogram> activeTraceMetricCollector, AgentStatMetricCollector<DataSourceMetricSnapshot> dataSourceMetricCollector, AgentStatMetricCollector<ResponseTimeValue> responseTimeMetricCollector, AgentStatMetricCollector<DeadlockMetricSnapshot> deadlockMetricCollector, AgentStatMetricCollector<FileDescriptorMetricSnapshot> fileDescriptorMetricCollector, AgentStatMetricCollector<BufferMetricSnapshot> bufferMetricCollector, AgentStatMetricCollector<TotalThreadMetricSnapshot> totalThreadMetricCollector, AgentStatMetricCollector<LoadedClassMetricSnapshot> loadedClassMetricCollector) {
        this.agentId = Objects.requireNonNull(agentId, "agentId");
        this.agentStartTimestamp = agentStartTimestamp;
        this.jvmGcMetricCollector = Objects.requireNonNull(jvmGcMetricCollector, "jvmGcMetricCollector");
        this.cpuLoadMetricCollector = Objects.requireNonNull(cpuLoadMetricCollector, "cpuLoadMetricCollector");
        this.transactionMetricCollector = Objects.requireNonNull(transactionMetricCollector, "transactionMetricCollector");
        this.activeTraceMetricCollector = Objects.requireNonNull(activeTraceMetricCollector, "activeTraceMetricCollector");
        this.dataSourceMetricCollector = Objects.requireNonNull(dataSourceMetricCollector, "dataSourceMetricCollector");
        this.responseTimeMetricCollector = Objects.requireNonNull(responseTimeMetricCollector, "responseTimeMetricCollector");
        this.deadlockMetricCollector = Objects.requireNonNull(deadlockMetricCollector, "deadlockMetricCollector");
        this.fileDescriptorMetricCollector = Objects.requireNonNull(fileDescriptorMetricCollector, "fileDescriptorMetricCollector");
        this.bufferMetricCollector = Objects.requireNonNull(bufferMetricCollector, "bufferMetricCollector");
        this.totalThreadMetricCollector = Objects.requireNonNull(totalThreadMetricCollector, "totalThreadMetricCollector");
        this.loadedClassMetricCollector = Objects.requireNonNull(loadedClassMetricCollector, "loadedClassMetricCollector");
    }

    @Override
    public AgentStatMetricSnapshot collect() {
        AgentStatMetricSnapshot agentStat = new AgentStatMetricSnapshot();
        agentStat.setAgentId(this.agentId);
        agentStat.setStartTimestamp(this.agentStartTimestamp);
        agentStat.setGc(this.jvmGcMetricCollector.collect());
        agentStat.setCpuLoad(this.cpuLoadMetricCollector.collect());
        agentStat.setTransaction(this.transactionMetricCollector.collect());
        agentStat.setActiveTrace(this.activeTraceMetricCollector.collect());
        agentStat.setDataSourceList(this.dataSourceMetricCollector.collect());
        agentStat.setResponseTime(this.responseTimeMetricCollector.collect());
        agentStat.setDeadlock(this.deadlockMetricCollector.collect());
        agentStat.setFileDescriptor(this.fileDescriptorMetricCollector.collect());
        agentStat.setDirectBuffer(this.bufferMetricCollector.collect());
        agentStat.setTotalThread(this.totalThreadMetricCollector.collect());
        agentStat.setLoadedClassCount(this.loadedClassMetricCollector.collect());
        return agentStat;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AgentStatCollector{");
        sb.append("agentId='").append(this.agentId).append('\'');
        sb.append(", agentStartTimestamp=").append(this.agentStartTimestamp);
        sb.append(", jvmGcMetricCollector=").append(this.jvmGcMetricCollector);
        sb.append(", cpuLoadMetricCollector=").append(this.cpuLoadMetricCollector);
        sb.append(", transactionMetricCollector=").append(this.transactionMetricCollector);
        sb.append(", activeTraceMetricCollector=").append(this.activeTraceMetricCollector);
        sb.append(", dataSourceMetricCollector=").append(this.dataSourceMetricCollector);
        sb.append(", responseTimeMetricCollector=").append(this.responseTimeMetricCollector);
        sb.append(", deadlockMetricCollector=").append(this.deadlockMetricCollector);
        sb.append(", fileDescriptorMetricCollector=").append(this.fileDescriptorMetricCollector);
        sb.append(", bufferMetricCollector=").append(this.bufferMetricCollector);
        sb.append(", totalThreadMetricCollector=").append(this.totalThreadMetricCollector);
        sb.append(", loadedClassMetricCollector=").append(this.loadedClassMetricCollector);
        sb.append('}');
        return sb.toString();
    }
}

