/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver.grpc;

import com.navercorp.pinpoint.grpc.trace.PCmdActiveThreadCountRes;
import com.navercorp.pinpoint.grpc.trace.PCmdRequest;
import com.navercorp.pinpoint.grpc.trace.PCommandType;
import com.navercorp.pinpoint.grpc.trace.ProfilerCommandServiceGrpc;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHistogram;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHistogramUtils;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceRepository;
import com.navercorp.pinpoint.profiler.receiver.grpc.ActiveThreadCountStreamSocket;
import com.navercorp.pinpoint.profiler.receiver.grpc.GrpcProfilerStreamSocket;
import com.navercorp.pinpoint.profiler.receiver.grpc.GrpcStreamService;
import com.navercorp.pinpoint.profiler.receiver.grpc.ProfilerGrpcCommandService;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GrpcActiveThreadCountService
implements ProfilerGrpcCommandService,
Closeable {
    private static final long DEFAULT_FLUSH_DELAY = 1000L;
    private static final Logger LOGGER = LogManager.getLogger(GrpcActiveThreadCountService.class);
    private final boolean isDebug = LOGGER.isDebugEnabled();
    private final ActiveTraceRepository activeTraceRepository;
    private final GrpcStreamService grpcStreamService = new GrpcStreamService("ActiveThreadCountService", 1000L);

    public GrpcActiveThreadCountService(ActiveTraceRepository activeTraceRepository) {
        this.activeTraceRepository = Objects.requireNonNull(activeTraceRepository, "activeTraceRepository");
    }

    @Override
    public short getCommandServiceCode() {
        return (short)PCommandType.ACTIVE_THREAD_COUNT.getNumber();
    }

    @Override
    public void handle(PCmdRequest request, ProfilerCommandServiceGrpc.ProfilerCommandServiceStub profilerCommandServiceStub) {
        ActiveThreadCountStreamSocket activeThreadCountStreamSocket = new ActiveThreadCountStreamSocket(request.getRequestId(), this.grpcStreamService);
        profilerCommandServiceStub.commandStreamActiveThreadCount((StreamObserver)activeThreadCountStreamSocket.getResponseObserver());
        this.grpcStreamService.register(activeThreadCountStreamSocket, new ActiveThreadCountTimerTask());
    }

    private PCmdActiveThreadCountRes.Builder getActiveThreadCountResponse() {
        long currentTime = System.currentTimeMillis();
        ActiveTraceHistogram histogram = this.activeTraceRepository.getActiveTraceHistogram(currentTime);
        PCmdActiveThreadCountRes.Builder responseBuilder = PCmdActiveThreadCountRes.newBuilder();
        responseBuilder.setTimeStamp(currentTime);
        responseBuilder.setHistogramSchemaType(histogram.getHistogramSchema().getTypeCode());
        List<Integer> activeTraceCountList = ActiveTraceHistogramUtils.asList(histogram);
        for (Integer activeTraceCount : activeTraceCountList) {
            responseBuilder.addActiveThreadCount(activeTraceCount.intValue());
        }
        return responseBuilder;
    }

    @Override
    public void close() throws IOException {
        LOGGER.info("close");
        this.grpcStreamService.close();
    }

    private class ActiveThreadCountTimerTask
    extends TimerTask {
        private ActiveThreadCountTimerTask() {
        }

        @Override
        public void run() {
            if (GrpcActiveThreadCountService.this.isDebug) {
                LOGGER.debug("ActiveThreadCountTimerTask started. streamSocketList:{}", (Object[])GrpcActiveThreadCountService.this.grpcStreamService.getStreamSocketList());
            }
            PCmdActiveThreadCountRes.Builder activeThreadCountResponseBuilder = GrpcActiveThreadCountService.this.getActiveThreadCountResponse();
            for (GrpcProfilerStreamSocket<?> streamSocket : GrpcActiveThreadCountService.this.grpcStreamService.getStreamSocketList()) {
                if (streamSocket == null) continue;
                try {
                    streamSocket.send(activeThreadCountResponseBuilder);
                }
                catch (Exception e) {
                    LOGGER.warn("failed to execute ActiveThreadCountTimerTask.run method. streamSocket:{}, message:{}", streamSocket, (Object)e.getMessage(), (Object)e);
                    streamSocket.close(e);
                }
            }
        }
    }
}

