/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.common.profiler.message.EnhancedDataSender;
import com.navercorp.pinpoint.common.profiler.message.MessageConverter;
import com.navercorp.pinpoint.grpc.client.ChannelFactory;
import com.navercorp.pinpoint.grpc.client.SocketIdClientInterceptor;
import com.navercorp.pinpoint.grpc.trace.AgentGrpc;
import com.navercorp.pinpoint.grpc.trace.PAgentInfo;
import com.navercorp.pinpoint.grpc.trace.PResult;
import com.navercorp.pinpoint.io.ResponseMessage;
import com.navercorp.pinpoint.profiler.receiver.ProfilerCommandServiceLocator;
import com.navercorp.pinpoint.profiler.receiver.grpc.CommandServiceStubFactory;
import com.navercorp.pinpoint.profiler.receiver.grpc.GrpcCommandService;
import com.navercorp.pinpoint.profiler.sender.grpc.GrpcDataSender;
import com.navercorp.pinpoint.profiler.sender.grpc.PingStreamContext;
import com.navercorp.pinpoint.profiler.sender.grpc.ReconnectExecutor;
import com.navercorp.pinpoint.profiler.sender.grpc.Reconnector;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;

public class AgentGrpcDataSender<T>
extends GrpcDataSender<T>
implements EnhancedDataSender<T, ResponseMessage> {
    private final AgentGrpc.AgentStub agentInfoStub;
    private final AgentGrpc.AgentStub agentPingStub;
    private final GrpcCommandService grpcCommandService;
    private final ReconnectExecutor reconnectExecutor;
    private volatile PingStreamContext pingStreamContext;
    private final Reconnector reconnector;

    public AgentGrpcDataSender(String host, int port, int executorQueueSize, MessageConverter<T, GeneratedMessageV3> messageConverter, ReconnectExecutor reconnectExecutor, final ScheduledExecutorService retransmissionExecutor, ChannelFactory channelFactory, ProfilerCommandServiceLocator profilerCommandServiceLocator) {
        super(host, port, executorQueueSize, messageConverter, channelFactory);
        this.agentInfoStub = AgentGrpc.newStub((Channel)this.managedChannel);
        this.agentPingStub = this.newAgentPingStub();
        this.reconnectExecutor = reconnectExecutor;
        CommandServiceStubFactory commandServiceStubFactory = new CommandServiceStubFactory(this.managedChannel);
        this.grpcCommandService = new GrpcCommandService(commandServiceStubFactory, reconnectExecutor, profilerCommandServiceLocator);
        Runnable reconnectJob = new Runnable(){

            @Override
            public void run() {
                AgentGrpcDataSender.this.pingStreamContext = AgentGrpcDataSender.this.newPingStream(AgentGrpcDataSender.this.agentPingStub, retransmissionExecutor);
            }
        };
        this.reconnector = reconnectExecutor.newReconnector(reconnectJob);
        reconnectJob.run();
    }

    private AgentGrpc.AgentStub newAgentPingStub() {
        AgentGrpc.AgentStub agentStub = AgentGrpc.newStub((Channel)this.managedChannel);
        return (AgentGrpc.AgentStub)agentStub.withInterceptors(new ClientInterceptor[]{new SocketIdClientInterceptor()});
    }

    private PingStreamContext newPingStream(AgentGrpc.AgentStub agentStub, ScheduledExecutorService reconnectScheduler) {
        PingStreamContext pingStreamContext = new PingStreamContext(agentStub, this.reconnector, reconnectScheduler);
        this.logger.info("newPingStream:{}", (Object)pingStreamContext);
        return pingStreamContext;
    }

    public boolean request(T data) {
        throw new UnsupportedOperationException("unsupported operation request(data)");
    }

    public boolean request(T data, int retryCount) {
        throw new UnsupportedOperationException("unsupported operation request(data, retryCount)");
    }

    public boolean request(T data, BiConsumer<ResponseMessage, Throwable> listener) {
        GeneratedMessageV3 message = (GeneratedMessageV3)this.messageConverter.toMessage(data);
        if (!(message instanceof PAgentInfo)) {
            throw new IllegalArgumentException("unsupported message " + data);
        }
        PAgentInfo pAgentInfo = (PAgentInfo)message;
        this.agentInfoStub.requestAgentInfo(pAgentInfo, (StreamObserver)new FutureListenerStreamObserver(listener));
        return true;
    }

    @Override
    public boolean send(Object data) {
        throw new UnsupportedOperationException("unsupported operation send(data)");
    }

    public void stop() {
        GrpcCommandService grpcCommandService;
        PingStreamContext pingStreamContext;
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.logger.info("Stop {}, channel={}", (Object)this.name, (Object)this.managedChannel);
        ReconnectExecutor reconnectExecutor = this.reconnectExecutor;
        if (reconnectExecutor != null) {
            reconnectExecutor.close();
        }
        if ((pingStreamContext = this.pingStreamContext) != null) {
            pingStreamContext.close();
        }
        if ((grpcCommandService = this.grpcCommandService) != null) {
            grpcCommandService.stop();
        }
        this.release();
    }

    private static class FutureListenerStreamObserver
    implements StreamObserver<PResult> {
        private final BiConsumer<ResponseMessage, Throwable> listener;

        private FutureListenerStreamObserver(BiConsumer<ResponseMessage, Throwable> listener) {
            this.listener = listener;
        }

        public void onNext(PResult result) {
            ResponseMessage response = ResponseMessage.wrap((byte[])result.toByteArray());
            this.listener.accept(response, null);
        }

        public void onError(Throwable throwable) {
            this.listener.accept(null, throwable);
        }

        public void onCompleted() {
        }
    }
}

