/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.navercorp.pinpoint.grpc.StatusError;
import com.navercorp.pinpoint.grpc.StatusErrors;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import org.apache.logging.log4j.Logger;

public class LogResponseStreamObserver<ResT>
implements StreamObserver<ResT> {
    private final Logger logger;

    public LogResponseStreamObserver(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    public void onNext(ResT response) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Request success. result={}", (Object)this.logString(response));
        }
    }

    public void onError(Throwable throwable) {
        StatusError statusError = StatusErrors.throwable((Throwable)throwable);
        if (statusError.isSimpleError()) {
            this.logger.info("Error. cause={}", (Object)statusError.getMessage());
        } else {
            this.logger.info("Error. cause={}", (Object)statusError.getMessage(), (Object)statusError.getThrowable());
        }
    }

    public void onCompleted() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("onCompleted");
        }
    }

    private String logString(Object message) {
        if (message == null) {
            return "NULL";
        }
        if (message instanceof GeneratedMessageV3) {
            GeneratedMessageV3 messageV3 = (GeneratedMessageV3)message;
            return TextFormat.shortDebugString((MessageOrBuilder)messageV3);
        }
        return message.toString();
    }

    public String toString() {
        return "LogResponseStreamObserver{logger=" + this.logger + '}';
    }
}

