/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.navercorp.pinpoint.profiler.context.grpc.config.GrpcTransportConfig;
import com.navercorp.pinpoint.profiler.sender.grpc.SubconnectionExpiringLoadBalancer;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import java.util.concurrent.TimeUnit;

public class SubconnectionExpiringLoadBalancerProvider
extends LoadBalancerProvider {
    private final long renewTransportPeriodMillis;

    public SubconnectionExpiringLoadBalancerProvider(GrpcTransportConfig config) {
        this.renewTransportPeriodMillis = config.getRenewTransportPeriodMillis();
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "subconnection_expiring_pick_first";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new SubconnectionExpiringLoadBalancer(helper, this.renewTransportPeriodMillis, TimeUnit.MILLISECONDS);
    }
}

