/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc.metric;

import com.google.common.base.MoreObjects;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.grpc.channelz.ChannelzUtils;
import com.navercorp.pinpoint.profiler.sender.grpc.metric.ChannelzReporter;
import io.grpc.InternalChannelz;
import io.grpc.InternalInstrumented;
import io.grpc.InternalWithLogId;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public class DefaultChannelzReporter
implements ChannelzReporter {
    private final Logger logger;
    private final InternalChannelz channelz = InternalChannelz.instance();
    private final ChannelStatsReporter reporter = new ChannelStatsReporter();

    public DefaultChannelzReporter(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    @Override
    public void reportRootChannel(long id) {
        InternalInstrumented iRootChannel = this.channelz.getRootChannel(id);
        if (iRootChannel == null) {
            this.logger.info("RootChannel not found:{}", (Object)id);
            return;
        }
        String rootChannelName = "RootChannel-" + id;
        InternalChannelz.ChannelStats channelStats = (InternalChannelz.ChannelStats)ChannelzUtils.getResult((String)rootChannelName, (InternalInstrumented)iRootChannel);
        if (channelStats == null) {
            this.logger.info("RootChannel channelStats.get() fail:{}", (Object)id);
            return;
        }
        this.reporter.reportChannelStats(rootChannelName, channelStats);
        this.reportSubChannel(id, channelStats.subchannels);
    }

    private void reportSubChannel(long rootChannelId, List<InternalWithLogId> subChannels) {
        for (InternalWithLogId subChannelLogId : subChannels) {
            String rootChannelName;
            InternalChannelz.ChannelStats subChannelStats;
            long subChannelId = subChannelLogId.getLogId().getId();
            InternalInstrumented iSubChannelState = this.channelz.getSubchannel(subChannelId);
            if (iSubChannelState == null || (subChannelStats = (InternalChannelz.ChannelStats)ChannelzUtils.getResult((String)(rootChannelName = rootChannelId + "-SubChannel-" + subChannelId), (InternalInstrumented)iSubChannelState)) == null) continue;
            this.reporter.reportChannelStats(rootChannelName, subChannelStats);
            for (InternalWithLogId socketId : subChannelStats.sockets) {
                this.reportSocketStats(subChannelId, socketId);
            }
        }
    }

    private void reportSocketStats(long channelId, InternalWithLogId socketLogId) {
        long socketId = socketLogId.getLogId().getId();
        InternalInstrumented iSocket = this.channelz.getSocket(socketId);
        if (iSocket == null) {
            return;
        }
        String socketName = channelId + "-Socket-" + socketId;
        InternalChannelz.SocketStats socketStats = (InternalChannelz.SocketStats)ChannelzUtils.getResult((String)socketName, (InternalInstrumented)iSocket);
        if (socketStats == null) {
            return;
        }
        MoreObjects.ToStringHelper title = MoreObjects.toStringHelper((String)"");
        title.add("local", (Object)socketStats.local);
        title.add("remote", (Object)socketStats.remote);
        title.add("security", (Object)socketStats.security);
        this.logger.info("{} {}", (Object)socketName, (Object)title);
        InternalChannelz.TransportStats transportStats = socketStats.data;
        if (transportStats != null) {
            MoreObjects.ToStringHelper socketStrHelper = MoreObjects.toStringHelper((String)"");
            socketStrHelper.add("streamsStarted", transportStats.streamsStarted);
            socketStrHelper.add("lastLocalStreamCreatedTime", DefaultChannelzReporter.toMillis(transportStats.lastLocalStreamCreatedTimeNanos));
            socketStrHelper.add("lastRemoteStreamCreatedTime", DefaultChannelzReporter.toMillis(transportStats.lastRemoteStreamCreatedTimeNanos));
            this.logger.info("{} {}", (Object)socketName, (Object)socketStrHelper);
            MoreObjects.ToStringHelper socketStatStrHelper = MoreObjects.toStringHelper((String)"");
            socketStatStrHelper.add("streamsSucceeded", transportStats.streamsSucceeded);
            socketStatStrHelper.add("streamsFailed", transportStats.streamsFailed);
            socketStatStrHelper.add("messagesSent", transportStats.messagesSent);
            socketStatStrHelper.add("messagesReceived", transportStats.messagesReceived);
            this.logger.info("{} {}", (Object)socketName, (Object)socketStatStrHelper);
            MoreObjects.ToStringHelper socketStat2StrHelper = MoreObjects.toStringHelper((String)"");
            socketStat2StrHelper.add("keepAlivesSent", transportStats.keepAlivesSent);
            socketStat2StrHelper.add("lastMessageSentTime", DefaultChannelzReporter.toMillis(transportStats.lastMessageSentTimeNanos));
            socketStat2StrHelper.add("lastMessageReceivedTime", DefaultChannelzReporter.toMillis(transportStats.lastMessageReceivedTimeNanos));
            socketStat2StrHelper.add("localFlowControlWindow", transportStats.localFlowControlWindow);
            socketStat2StrHelper.add("remoteFlowControlWindow", transportStats.remoteFlowControlWindow);
            this.logger.info("{} {}", (Object)socketName, (Object)socketStat2StrHelper);
        }
    }

    public String toLogIds(List<InternalWithLogId> logIdList) {
        long[] longs = this.toLogIdArray(logIdList);
        return Arrays.toString(longs);
    }

    public long[] toLogIdArray(List<InternalWithLogId> logIdList) {
        if (logIdList == null) {
            return new long[0];
        }
        long[] longs = new long[logIdList.size()];
        for (int i = 0; i < logIdList.size(); ++i) {
            InternalWithLogId internalWithLogId = logIdList.get(i);
            longs[i] = internalWithLogId.getLogId().getId();
        }
        return longs;
    }

    public static long toMillis(long duration) {
        return TimeUnit.NANOSECONDS.toMillis(duration);
    }

    public class ChannelStatsReporter {
        public void reportChannelStats(String name, InternalChannelz.ChannelStats channelStats) {
            InternalChannelz.ChannelTrace channelTrace;
            if (!DefaultChannelzReporter.this.logger.isInfoEnabled()) {
                return;
            }
            MoreObjects.ToStringHelper title = MoreObjects.toStringHelper((String)"");
            title.add("target", (Object)channelStats.target);
            title.add("stat", (Object)channelStats.state);
            DefaultChannelzReporter.this.logger.info("{} {}", (Object)name, (Object)title);
            MoreObjects.ToStringHelper counter = MoreObjects.toStringHelper((String)"");
            counter.add("callsFailed", channelStats.callsFailed);
            counter.add("callsStarted", channelStats.callsStarted);
            counter.add("callsSucceeded", channelStats.callsSucceeded);
            counter.add("lastCallStarted", DefaultChannelzReporter.toMillis(channelStats.lastCallStartedNanos));
            DefaultChannelzReporter.this.logger.info("{} {}", (Object)name, (Object)counter);
            if (CollectionUtils.hasLength((Collection)channelStats.sockets)) {
                DefaultChannelzReporter.this.logger.info("{} sockets:{}", (Object)name, (Object)DefaultChannelzReporter.this.toLogIds(channelStats.sockets));
            }
            if (CollectionUtils.hasLength((Collection)channelStats.subchannels)) {
                DefaultChannelzReporter.this.logger.info("{} subchannels:{}", (Object)name, (Object)DefaultChannelzReporter.this.toLogIds(channelStats.subchannels));
            }
            if ((channelTrace = channelStats.channelTrace) != null) {
                MoreObjects.ToStringHelper traceStrHelper = MoreObjects.toStringHelper((String)"");
                traceStrHelper.add("numEventsLogged", channelTrace.numEventsLogged);
                traceStrHelper.add("creationTime", DefaultChannelzReporter.toMillis(channelTrace.creationTimeNanos));
                traceStrHelper.add("events.size", channelTrace.events.size());
                DefaultChannelzReporter.this.logger.info("{} channelTrace {}", (Object)name, (Object)traceStrHelper);
                for (InternalChannelz.ChannelTrace.Event event : channelTrace.events) {
                    DefaultChannelzReporter.this.logger.info("{} channelTrace.events:{}", (Object)name, (Object)this.toString(event));
                }
            }
        }

        private String toString(InternalChannelz.ChannelTrace.Event event) {
            MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper((Object)event);
            stringHelper.add("description", (Object)event.description);
            stringHelper.add("severity", (Object)event.severity);
            stringHelper.add("timestamp", DefaultChannelzReporter.toMillis(event.timestampNanos));
            if (event.channelRef != null) {
                stringHelper.add("channelRef", (Object)event.channelRef);
            }
            if (event.subchannelRef != null) {
                stringHelper.add("subchannelRef", (Object)event.subchannelRef);
            }
            return stringHelper.toString();
        }
    }
}

