/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.transformer;

import com.navercorp.pinpoint.common.util.CodeSourceUtils;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.lang.instrument.ClassFileTransformer;
import java.net.URL;
import java.security.ProtectionDomain;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseClassFileTransformer {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ClassLoader agentClassLoader;

    public BaseClassFileTransformer(ClassLoader agentClassLoader) {
        this.agentClassLoader = agentClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] transform(ClassLoader classLoader, String classInternalName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer, ClassFileTransformer transformer) {
        String className = JavaAssistUtils.jvmNameToJavaName(classInternalName);
        if (this.logger.isDebugEnabled()) {
            URL codeLocation = CodeSourceUtils.getCodeLocation((ProtectionDomain)protectionDomain);
            String transform = this.getTransformState(classBeingRedefined);
            this.logger.debug("[{}] classLoader:{} className:{} transformer:{} codeSource:{}", (Object)transform, (Object)classLoader, (Object)className, (Object)transformer.getClass().getName(), (Object)codeLocation);
        }
        Thread thread = Thread.currentThread();
        ClassLoader before = this.getContextClassLoader(thread);
        thread.setContextClassLoader(this.agentClassLoader);
        try {
            byte[] byArray = transformer.transform(classLoader, className, classBeingRedefined, protectionDomain, classFileBuffer);
            thread.setContextClassLoader(before);
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                thread.setContextClassLoader(before);
                throw throwable;
            }
            catch (Throwable e) {
                URL codeLocation = CodeSourceUtils.getCodeLocation((ProtectionDomain)protectionDomain);
                this.logger.error("Transformer:{} threw an exception. codeLocation:{} cl:{} ctxCl:{} agentCl:{} Cause:{}", (Object)transformer.getClass().getName(), (Object)codeLocation, (Object)classLoader, (Object)Thread.currentThread().getContextClassLoader(), (Object)this.agentClassLoader, (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
    }

    private String getTransformState(Class<?> classBeingRedefined) {
        if (classBeingRedefined == null) {
            return "transform";
        }
        return "retransform";
    }

    private ClassLoader getContextClassLoader(Thread thread) throws Throwable {
        try {
            return thread.getContextClassLoader();
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Throwable th) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("getContextClassLoader(). Caused:{}", (Object)th.getMessage(), (Object)th);
            }
            throw th;
        }
    }
}

