/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertyRollbackTemplate {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Properties properties;
    private final List<ExecuteContext<String>> contexts = new ArrayList<ExecuteContext<String>>();

    public PropertyRollbackTemplate(Properties properties) {
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    public void addKey(String key, String value) {
        ExecuteContext context = new ExecuteContext(key, value);
        this.contexts.add(context);
    }

    public <V> void execute(Runnable runnable) {
        Objects.requireNonNull(runnable, "runnable");
        ArrayList<BeforeState> beforeStates = new ArrayList<BeforeState>(this.contexts.size());
        for (ExecuteContext<String> context : this.contexts) {
            BeforeState beforeState = ((ExecuteContext)context).prepare(this.properties);
            beforeStates.add(beforeState);
        }
        runnable.run();
        List<ExecuteContext<String>> rollbackContexts = this.copyAndReverse(this.contexts);
        Collections.reverse(beforeStates);
        for (int i = 0; i < rollbackContexts.size(); ++i) {
            ExecuteContext<String> rollbackContext = rollbackContexts.get(i);
            BeforeState beforeState = (BeforeState)beforeStates.get(i);
            ((ExecuteContext)rollbackContext).rollback(this.properties, beforeState);
        }
    }

    private <T> List<T> copyAndReverse(List<T> list) {
        ArrayList<T> rollbackContexts = new ArrayList<T>(list);
        Collections.reverse(rollbackContexts);
        return rollbackContexts;
    }

    private static class BeforeState<V> {
        final boolean hasValue;
        private final V backupValue;

        BeforeState(boolean hasValue, V backupValue) {
            this.hasValue = hasValue;
            this.backupValue = backupValue;
        }

        boolean hasValue() {
            return this.hasValue;
        }

        V getBackupValue() {
            return this.backupValue;
        }
    }

    private class ExecuteContext<V> {
        private final String key;
        private final V value;

        private ExecuteContext(String key, V value) {
            this.key = Objects.requireNonNull(key, "key");
            this.value = Objects.requireNonNull(value, "value");
        }

        private BeforeState<String> prepare(Properties properties) {
            boolean hasValue = properties.containsKey(this.key);
            String backupValue = properties.getProperty(this.key, null);
            PropertyRollbackTemplate.this.logger.debug("prepare put key:{} value:{}", (Object)this.key, this.value);
            properties.put(this.key, (Object)this.value);
            return new BeforeState<String>(hasValue, backupValue);
        }

        private void rollback(Properties properties, BeforeState<String> beforeState) {
            if (!beforeState.hasValue()) {
                PropertyRollbackTemplate.this.logger.debug("rollback remove key:{}", (Object)this.key);
                properties.remove(this.key);
            } else {
                String backupValue = beforeState.getBackupValue();
                PropertyRollbackTemplate.this.logger.debug("rollback put key:{} value:{}", (Object)this.key, (Object)backupValue);
                properties.put(this.key, backupValue);
            }
        }
    }
}

