/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context;

import com.slack.api.app_backend.interactive_components.response.ActionResponse;
import com.slack.api.bolt.context.RespondUtility;
import com.slack.api.bolt.util.BuilderConfigurator;
import com.slack.api.bolt.util.Responder;
import com.slack.api.model.block.LayoutBlock;
import com.slack.api.webhook.WebhookResponse;
import java.io.IOException;
import java.util.List;

public interface ActionRespondUtility
extends RespondUtility {
    default public WebhookResponse respond(String text) throws IOException {
        return this.respond(ActionResponse.builder().text(text).build());
    }

    default public WebhookResponse respond(List<LayoutBlock> blocks) throws IOException {
        return this.respond(ActionResponse.builder().blocks(blocks).build());
    }

    default public WebhookResponse respond(ActionResponse response) throws IOException {
        if (this.getResponder() == null) {
            this.setResponder(new Responder(this.getSlack(), this.getResponseUrl()));
        }
        return this.getResponder().send(response);
    }

    default public WebhookResponse respond(BuilderConfigurator<ActionResponse.ActionResponseBuilder> builder) throws IOException {
        return this.respond(builder.configure(ActionResponse.builder()).build());
    }
}

