/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context;

import com.slack.api.methods.MethodsClient;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.request.chat.ChatPostMessageRequest;
import com.slack.api.methods.response.chat.ChatPostMessageResponse;
import com.slack.api.model.block.LayoutBlock;
import java.io.IOException;
import java.util.List;

public interface SayUtility {
    public String getChannelId();

    public MethodsClient client();

    default public ChatPostMessageResponse say(String text) throws IOException, SlackApiException {
        this.verifyChannelId();
        ChatPostMessageResponse response = this.client().chatPostMessage(ChatPostMessageRequest.builder().text(text).channel(this.getChannelId()).build());
        return response;
    }

    default public ChatPostMessageResponse say(List<LayoutBlock> blocks) throws IOException, SlackApiException {
        return this.say(null, blocks);
    }

    default public ChatPostMessageResponse say(String text, List<LayoutBlock> blocks) throws IOException, SlackApiException {
        this.verifyChannelId();
        ChatPostMessageResponse response = this.client().chatPostMessage(ChatPostMessageRequest.builder().text(text).blocks(blocks).channel(this.getChannelId()).build());
        return response;
    }

    default public void verifyChannelId() {
        if (this.getChannelId() == null || this.getChannelId().trim().isEmpty()) {
            throw new IllegalStateException("This request doesn't have a channel to post reply to.");
        }
    }
}

