/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.meta.raft;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.eventmesh.meta.raft.EventOperation;
import org.apache.eventmesh.meta.raft.rpc.RequestResponse;

public abstract class EventClosure
implements Closure {
    private CompletableFuture<RequestResponse> future;
    private RequestResponse requestResponse;
    private EventOperation eventOperation;

    public static EventClosure createDefaultEventClosure() {
        return new EventClosure(){

            public void run(Status status) {
            }
        };
    }

    public void setFuture(CompletableFuture<RequestResponse> future) {
        this.future = future;
    }

    public void setRequestResponse(RequestResponse requestResponse) {
        this.requestResponse = requestResponse;
        if (this.future != null) {
            this.future.complete(this.getRequestResponse());
        }
    }

    public RequestResponse getRequestResponse() {
        return this.requestResponse;
    }

    public EventOperation getEventOperation() {
        return this.eventOperation;
    }

    protected void failure(String errorMsg, String redirect) {
        RequestResponse response = RequestResponse.newBuilder().setSuccess(false).setErrorMsg(errorMsg).setRedirect(redirect).build();
        this.setRequestResponse(response);
    }

    public void setEventOperation(EventOperation opreation) {
        this.eventOperation = opreation;
    }

    protected void success(Map<String, String> map) {
        RequestResponse response = RequestResponse.newBuilder().setValue(4L).setSuccess(true).putAllInfo(map).build();
        this.setRequestResponse(response);
    }
}

