/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.meta.raft;

import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.RaftGroupService;
import com.alipay.sofa.jraft.StateMachine;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.rpc.RaftRpcServerFactory;
import com.alipay.sofa.jraft.rpc.RpcProcessor;
import com.alipay.sofa.jraft.rpc.RpcServer;
import com.alipay.sofa.jraft.util.Endpoint;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.eventmesh.meta.raft.JraftMetaServiceImpl;
import org.apache.eventmesh.meta.raft.MetaStateMachine;
import org.apache.eventmesh.meta.raft.rpc.MetaServerHelper;
import org.apache.eventmesh.meta.raft.rpc.RequestProcessor;
import org.apache.eventmesh.meta.raft.rpc.RequestResponse;

public class JraftServer {
    private RaftGroupService raftGroupService;
    private Node node;
    private MetaStateMachine fsm = new MetaStateMachine();
    private JraftMetaServiceImpl metaImpl;

    public MetaStateMachine getFsm() {
        return this.fsm;
    }

    public JraftServer(String dataPath, String groupId, PeerId serverId, NodeOptions nodeOptions) throws IOException {
        FileUtils.forceMkdir((File)new File(dataPath));
        RpcServer rpcServer = RaftRpcServerFactory.createRaftRpcServer((Endpoint)serverId.getEndpoint());
        MetaServerHelper.initGRpc();
        MetaServerHelper.setRpcServer(rpcServer);
        this.metaImpl = new JraftMetaServiceImpl(this);
        rpcServer.registerProcessor((RpcProcessor)new RequestProcessor(this.metaImpl));
        nodeOptions.setFsm((StateMachine)this.fsm);
        nodeOptions.setLogUri(dataPath + File.separator + "log");
        nodeOptions.setRaftMetaUri(dataPath + File.separator + "raft_meta");
        nodeOptions.setSnapshotUri(dataPath + File.separator + "snapshot");
        this.raftGroupService = new RaftGroupService(groupId, serverId, nodeOptions, rpcServer);
        this.node = this.raftGroupService.start();
    }

    public RequestResponse redirect() {
        PeerId leader;
        RequestResponse.Builder builder = RequestResponse.newBuilder().setSuccess(false);
        if (this.node != null && (leader = this.node.getLeaderId()) != null) {
            builder.setRedirect(leader.toString());
        }
        return builder.build();
    }

    public JraftMetaServiceImpl getMetaImpl() {
        return this.metaImpl;
    }

    public Node getNode() {
        return this.node;
    }
}

