/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql;

import com.alibaba.otter.canal.common.utils.JsonUtils;
import com.alibaba.otter.canal.parse.CanalEventParser;
import com.alibaba.otter.canal.parse.CanalHASwitchable;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.FieldPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.ResultSetPacket;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.ha.CanalHAController;
import com.alibaba.otter.canal.parse.inbound.ErosaConnection;
import com.alibaba.otter.canal.parse.inbound.HeartBeatCallback;
import com.alibaba.otter.canal.parse.inbound.SinkFunction;
import com.alibaba.otter.canal.parse.inbound.mysql.AbstractMysqlEventParser;
import com.alibaba.otter.canal.parse.inbound.mysql.MysqlConnection;
import com.alibaba.otter.canal.parse.inbound.mysql.SlaveEntryPosition;
import com.alibaba.otter.canal.parse.inbound.mysql.dbsync.LogEventConvert;
import com.alibaba.otter.canal.parse.inbound.mysql.dbsync.TableMetaCache;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.DatabaseTableMeta;
import com.alibaba.otter.canal.parse.support.AuthenticationInfo;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.position.EntryPosition;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import com.taobao.tddl.dbsync.binlog.LogEvent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public class MysqlEventParser
extends AbstractMysqlEventParser
implements CanalEventParser,
CanalHASwitchable {
    private CanalHAController haController = null;
    private int defaultConnectionTimeoutInSeconds = 30;
    private int receiveBufferSize = 65536;
    private int sendBufferSize = 65536;
    protected AuthenticationInfo masterInfo;
    protected AuthenticationInfo standbyInfo;
    protected EntryPosition masterPosition;
    protected EntryPosition standbyPosition;
    private long slaveId;
    private String detectingSQL;
    private MysqlConnection metaConnection;
    private TableMetaCache tableMetaCache;
    private int fallbackIntervalInSeconds = 60;
    private MysqlConnection.BinlogFormat[] supportBinlogFormats;
    private MysqlConnection.BinlogImage[] supportBinlogImages;
    private int dumpErrorCount = 0;
    private int dumpErrorCountThreshold = 2;
    private boolean rdsOssMode = false;
    private boolean autoResetLatestPosMode = false;
    private boolean multiStreamEnable;

    @Override
    protected ErosaConnection buildErosaConnection() {
        return this.buildMysqlConnection(this.runningInfo);
    }

    @Override
    protected void preDump(ErosaConnection connection) {
        if (!(connection instanceof MysqlConnection)) {
            throw new CanalParseException("Unsupported connection type : " + connection.getClass().getSimpleName());
        }
        if (this.binlogParser != null && this.binlogParser instanceof LogEventConvert) {
            boolean found;
            this.metaConnection = (MysqlConnection)connection.fork();
            try {
                this.metaConnection.connect();
            }
            catch (IOException e) {
                throw new CanalParseException(e);
            }
            if (this.supportBinlogFormats != null && this.supportBinlogFormats.length > 0) {
                MysqlConnection.BinlogFormat format = this.metaConnection.getBinlogFormat();
                found = false;
                for (Enum enum_ : this.supportBinlogFormats) {
                    if (enum_ == null || format != enum_) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new CanalParseException("Unsupported BinlogFormat " + (Object)((Object)format));
                }
            }
            if (this.supportBinlogImages != null && this.supportBinlogImages.length > 0) {
                MysqlConnection.BinlogImage image = this.metaConnection.getBinlogImage();
                found = false;
                for (Enum enum_ : this.supportBinlogImages) {
                    if (enum_ == null || image != enum_) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new CanalParseException("Unsupported BinlogImage " + (Object)((Object)image));
                }
            }
            if (this.tableMetaTSDB != null && this.tableMetaTSDB instanceof DatabaseTableMeta) {
                ((DatabaseTableMeta)this.tableMetaTSDB).setConnection(this.metaConnection);
                ((DatabaseTableMeta)this.tableMetaTSDB).setFilter(this.eventFilter);
                ((DatabaseTableMeta)this.tableMetaTSDB).setBlackFilter(this.eventBlackFilter);
                ((DatabaseTableMeta)this.tableMetaTSDB).setSnapshotInterval(this.tsdbSnapshotInterval);
                ((DatabaseTableMeta)this.tableMetaTSDB).setSnapshotExpire(this.tsdbSnapshotExpire);
                ((DatabaseTableMeta)this.tableMetaTSDB).init(this.destination);
            }
            this.tableMetaCache = new TableMetaCache(this.metaConnection, this.tableMetaTSDB);
            ((LogEventConvert)this.binlogParser).setTableMetaCache(this.tableMetaCache);
        }
    }

    @Override
    protected void afterDump(ErosaConnection connection) {
        super.afterDump(connection);
        if (connection == null) {
            throw new CanalParseException("illegal connection is null");
        }
        if (!(connection instanceof MysqlConnection)) {
            throw new CanalParseException("Unsupported connection type : " + connection.getClass().getSimpleName());
        }
        if (this.metaConnection != null) {
            try {
                this.metaConnection.disconnect();
            }
            catch (IOException e) {
                this.logger.error("ERROR # disconnect meta connection for address:{}", (Object)this.metaConnection.getConnector().getAddress(), (Object)e);
            }
        }
    }

    @Override
    public void start() throws CanalParseException {
        if (this.runningInfo == null) {
            this.runningInfo = this.masterInfo;
        }
        super.start();
    }

    @Override
    public void stop() throws CanalParseException {
        if (this.metaConnection != null) {
            try {
                this.metaConnection.disconnect();
            }
            catch (IOException e) {
                this.logger.error("ERROR # disconnect meta connection for address:{}", (Object)this.metaConnection.getConnector().getAddress(), (Object)e);
            }
        }
        if (this.tableMetaCache != null) {
            this.tableMetaCache.clearTableMeta();
        }
        super.stop();
    }

    @Override
    protected TimerTask buildHeartBeatTimeTask(ErosaConnection connection) {
        if (!(connection instanceof MysqlConnection)) {
            throw new CanalParseException("Unsupported connection type : " + connection.getClass().getSimpleName());
        }
        if (this.detectingEnable && StringUtils.isNotBlank((String)this.detectingSQL)) {
            return new MysqlDetectingTimeTask((MysqlConnection)connection.fork());
        }
        return super.buildHeartBeatTimeTask(connection);
    }

    @Override
    protected void stopHeartBeat() {
        TimerTask heartBeatTimerTask = this.heartBeatTimerTask;
        super.stopHeartBeat();
        if (heartBeatTimerTask != null && heartBeatTimerTask instanceof MysqlDetectingTimeTask) {
            MysqlConnection mysqlConnection = ((MysqlDetectingTimeTask)heartBeatTimerTask).getMysqlConnection();
            try {
                mysqlConnection.disconnect();
            }
            catch (IOException e) {
                this.logger.error("ERROR # disconnect heartbeat connection for address:{}", (Object)mysqlConnection.getConnector().getAddress(), (Object)e);
            }
        }
    }

    @Override
    public void doSwitch() {
        AuthenticationInfo newRunningInfo = this.runningInfo.equals(this.masterInfo) ? this.standbyInfo : this.masterInfo;
        this.doSwitch(newRunningInfo);
    }

    @Override
    public void doSwitch(AuthenticationInfo newRunningInfo) {
        String alarmMessage = null;
        if (this.runningInfo.equals(newRunningInfo)) {
            alarmMessage = "same runingInfo switch again : " + this.runningInfo.getAddress().toString();
            this.logger.warn(alarmMessage);
            return;
        }
        if (newRunningInfo == null) {
            alarmMessage = "no standby config, just do nothing, will continue try:" + this.runningInfo.getAddress().toString();
            this.logger.warn(alarmMessage);
            this.sendAlarm(this.destination, alarmMessage);
            return;
        }
        this.stop();
        alarmMessage = "try to ha switch, old:" + this.runningInfo.getAddress().toString() + ", new:" + newRunningInfo.getAddress().toString();
        this.logger.warn(alarmMessage);
        this.sendAlarm(this.destination, alarmMessage);
        this.runningInfo = newRunningInfo;
        this.start();
    }

    private MysqlConnection buildMysqlConnection(AuthenticationInfo runningInfo) {
        MysqlConnection connection = new MysqlConnection(runningInfo.getAddress(), runningInfo.getUsername(), runningInfo.getPassword(), this.connectionCharsetNumber, runningInfo.getDefaultDatabaseName());
        connection.getConnector().setReceiveBufferSize(this.receiveBufferSize);
        connection.getConnector().setSendBufferSize(this.sendBufferSize);
        connection.getConnector().setSoTimeout(this.defaultConnectionTimeoutInSeconds * 1000);
        connection.setCharset(this.connectionCharset);
        connection.setReceivedBinlogBytes(this.receivedBinlogBytes);
        if (this.slaveId <= 0L) {
            this.slaveId = this.generateUniqueServerId();
        }
        connection.setSlaveId(this.slaveId);
        return connection;
    }

    private final long generateUniqueServerId() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            byte[] addr = localHost.getAddress();
            int salt = this.destination != null ? this.destination.hashCode() : 0;
            return ((0x7F & salt) << 24) + ((0xFF & addr[1]) << 16) + ((0xFF & addr[2]) << 8) + (0xFF & addr[3]);
        }
        catch (UnknownHostException e) {
            throw new CanalParseException("Unknown host", e);
        }
    }

    @Override
    protected EntryPosition findStartPosition(ErosaConnection connection) throws IOException {
        if (this.isGTIDMode()) {
            LogPosition logPosition = this.getLogPositionManager().getLatestIndexBy(this.destination);
            if (logPosition != null) {
                if (StringUtils.isNotEmpty((String)logPosition.getPostion().getGtid())) {
                    return logPosition.getPostion();
                }
            } else if (this.masterPosition != null && StringUtils.isNotEmpty((String)this.masterPosition.getGtid())) {
                return this.masterPosition;
            }
        }
        EntryPosition startPosition = this.findStartPositionInternal(connection);
        if (this.needTransactionPosition.get()) {
            this.logger.warn("prepare to find last position : {}", (Object)startPosition.toString());
            Long preTransactionStartPosition = this.findTransactionBeginPosition(connection, startPosition);
            if (!preTransactionStartPosition.equals(startPosition.getPosition())) {
                this.logger.warn("find new start Transaction Position , old : {} , new : {}", (Object)startPosition.getPosition(), (Object)preTransactionStartPosition);
                startPosition.setPosition(preTransactionStartPosition);
            }
            this.needTransactionPosition.compareAndSet(true, false);
        }
        return startPosition;
    }

    protected EntryPosition findEndPosition(ErosaConnection connection) throws IOException {
        MysqlConnection mysqlConnection = (MysqlConnection)connection;
        EntryPosition endPosition = this.findEndPosition(mysqlConnection);
        return endPosition;
    }

    protected EntryPosition findEndPositionWithMasterIdAndTimestamp(MysqlConnection connection) {
        MysqlConnection mysqlConnection = connection;
        EntryPosition endPosition = this.findEndPosition(mysqlConnection);
        if (this.tableMetaTSDB != null || this.isGTIDMode()) {
            long startTimestamp = System.currentTimeMillis();
            return this.findAsPerTimestampInSpecificLogFile(mysqlConnection, startTimestamp, endPosition, endPosition.getJournalName(), true);
        }
        return endPosition;
    }

    protected EntryPosition findPositionWithMasterIdAndTimestamp(MysqlConnection connection, EntryPosition fixedPosition) {
        MysqlConnection mysqlConnection = connection;
        if (this.tableMetaTSDB != null && (fixedPosition.getTimestamp() == null || fixedPosition.getTimestamp() <= 0L)) {
            long startTimestamp = System.currentTimeMillis() + 3216672000000L;
            EntryPosition entryPosition = this.findAsPerTimestampInSpecificLogFile(mysqlConnection, startTimestamp, fixedPosition, fixedPosition.getJournalName(), true);
            if (entryPosition == null) {
                throw new CanalParseException("[fixed timestamp] can't found begin/commit position before with fixed position " + fixedPosition.getJournalName() + ":" + fixedPosition.getPosition());
            }
            return entryPosition;
        }
        return fixedPosition;
    }

    protected EntryPosition findStartPositionInternal(ErosaConnection connection) {
        MysqlConnection mysqlConnection = (MysqlConnection)connection;
        LogPosition logPosition = this.logPositionManager.getLatestIndexBy(this.destination);
        if (logPosition == null) {
            EntryPosition endPosition;
            EntryPosition entryPosition = null;
            if (this.masterInfo != null && mysqlConnection.getConnector().getAddress().equals(this.masterInfo.getAddress())) {
                entryPosition = this.masterPosition;
            } else if (this.standbyInfo != null && mysqlConnection.getConnector().getAddress().equals(this.standbyInfo.getAddress())) {
                entryPosition = this.standbyPosition;
            }
            if (entryPosition == null) {
                entryPosition = this.findEndPositionWithMasterIdAndTimestamp(mysqlConnection);
            }
            if (StringUtils.isEmpty((String)entryPosition.getJournalName())) {
                if (entryPosition.getTimestamp() != null && entryPosition.getTimestamp() > 0L) {
                    this.logger.warn("prepare to find start position {}:{}:{}", new Object[]{"", "", entryPosition.getTimestamp()});
                    return this.findByStartTimeStamp(mysqlConnection, entryPosition.getTimestamp());
                }
                this.logger.warn("prepare to find start position just show master status");
                return this.findEndPositionWithMasterIdAndTimestamp(mysqlConnection);
            }
            if (entryPosition.getPosition() != null && entryPosition.getPosition() > 0L) {
                entryPosition = this.findPositionWithMasterIdAndTimestamp(mysqlConnection, entryPosition);
                this.logger.warn("prepare to find start position {}:{}:{}", new Object[]{entryPosition.getJournalName(), entryPosition.getPosition(), entryPosition.getTimestamp()});
                return entryPosition;
            }
            EntryPosition specificLogFilePosition = null;
            if (entryPosition.getTimestamp() != null && entryPosition.getTimestamp() > 0L && (endPosition = this.findEndPosition(mysqlConnection)) != null) {
                this.logger.warn("prepare to find start position {}:{}:{}", new Object[]{entryPosition.getJournalName(), "", entryPosition.getTimestamp()});
                specificLogFilePosition = this.findAsPerTimestampInSpecificLogFile(mysqlConnection, entryPosition.getTimestamp(), endPosition, entryPosition.getJournalName(), true);
            }
            if (specificLogFilePosition == null) {
                if (this.isRdsOssMode()) {
                    return null;
                }
                entryPosition.setPosition(Long.valueOf(4L));
                return entryPosition;
            }
            return specificLogFilePosition;
        }
        if (logPosition.getIdentity().getSourceAddress().equals(mysqlConnection.getConnector().getAddress())) {
            if (this.dumpErrorCountThreshold >= 0 && this.dumpErrorCount > this.dumpErrorCountThreshold) {
                boolean case2;
                boolean bl = case2 = (this.standbyInfo == null || this.standbyInfo.getAddress() == null) && logPosition.getPostion().getServerId() != null && !logPosition.getPostion().getServerId().equals(this.findServerId(mysqlConnection));
                if (case2) {
                    EntryPosition findPosition = this.fallbackFindByStartTimestamp(logPosition, mysqlConnection);
                    this.dumpErrorCount = 0;
                    return findPosition;
                }
                if (this.isAutoResetLatestPosMode()) {
                    this.dumpErrorCount = 0;
                    return this.findEndPosition(mysqlConnection);
                }
                Long timestamp = logPosition.getPostion().getTimestamp();
                if (this.isRdsOssMode() && timestamp != null && timestamp > 0L) {
                    return null;
                }
            } else if (StringUtils.isBlank((String)logPosition.getPostion().getJournalName()) && logPosition.getPostion().getPosition() <= 0L && logPosition.getPostion().getTimestamp() > 0L) {
                return this.fallbackFindByStartTimestamp(logPosition, mysqlConnection);
            }
            this.logger.warn("prepare to find start position just last position\n {}", (Object)JsonUtils.marshalToString((Object)logPosition));
            return logPosition.getPostion();
        }
        long newStartTimestamp = logPosition.getPostion().getTimestamp() - (long)(this.fallbackIntervalInSeconds * 1000);
        this.logger.warn("prepare to find start position by switch {}:{}:{}", new Object[]{"", "", logPosition.getPostion().getTimestamp()});
        return this.findByStartTimeStamp(mysqlConnection, newStartTimestamp);
    }

    protected EntryPosition fallbackFindByStartTimestamp(LogPosition logPosition, MysqlConnection mysqlConnection) {
        long timestamp = logPosition.getPostion().getTimestamp();
        long newStartTimestamp = timestamp - (long)(this.fallbackIntervalInSeconds * 1000);
        this.logger.warn("prepare to find start position by last position {}:{}:{}", new Object[]{"", "", logPosition.getPostion().getTimestamp()});
        return this.findByStartTimeStamp(mysqlConnection, newStartTimestamp);
    }

    private Long findTransactionBeginPosition(ErosaConnection mysqlConnection, final EntryPosition entryPosition) throws IOException {
        final AtomicLong preTransactionStartPosition = new AtomicLong(0L);
        mysqlConnection.reconnect();
        mysqlConnection.seek(entryPosition.getJournalName(), 4L, entryPosition.getGtid(), new SinkFunction<LogEvent>(){
            private LogPosition lastPosition;

            @Override
            public boolean sink(LogEvent event) {
                try {
                    CanalEntry.Entry entry = MysqlEventParser.this.parseAndProfilingIfNecessary(event, true);
                    if (entry == null) {
                        return true;
                    }
                    if (entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONBEGIN && entry.getHeader().getLogfileOffset() < entryPosition.getPosition()) {
                        preTransactionStartPosition.set(entry.getHeader().getLogfileOffset());
                    }
                    if (entry.getHeader().getLogfileOffset() >= entryPosition.getPosition()) {
                        return false;
                    }
                    this.lastPosition = MysqlEventParser.this.buildLastPosition(entry);
                }
                catch (Exception e) {
                    MysqlEventParser.this.processSinkError(e, this.lastPosition, entryPosition.getJournalName(), entryPosition.getPosition());
                    return false;
                }
                return MysqlEventParser.this.running;
            }
        });
        if (preTransactionStartPosition.get() > entryPosition.getPosition()) {
            this.logger.error("preTransactionEndPosition greater than startPosition from zk or localconf, maybe lost data");
            throw new CanalParseException("preTransactionStartPosition greater than startPosition from zk or localconf, maybe lost data");
        }
        return preTransactionStartPosition.get();
    }

    private EntryPosition findByStartTimeStamp(MysqlConnection mysqlConnection, Long startTimestamp) {
        EntryPosition endPosition = this.findEndPosition(mysqlConnection);
        EntryPosition startPosition = this.findStartPosition(mysqlConnection);
        String maxBinlogFileName = endPosition.getJournalName();
        String minBinlogFileName = startPosition.getJournalName();
        this.logger.info("show master status to set search end condition:{} ", (Object)endPosition);
        String startSearchBinlogFile = endPosition.getJournalName();
        boolean shouldBreak = false;
        while (this.running && !shouldBreak) {
            String binlogFileNameSuffix;
            String binlogFileNamePrefix;
            int nextBinlogSeqNum;
            int binlogSeqNum;
            try {
                EntryPosition entryPosition = this.findAsPerTimestampInSpecificLogFile(mysqlConnection, startTimestamp, endPosition, startSearchBinlogFile, false);
                if (entryPosition == null) {
                    if (StringUtils.equalsIgnoreCase((String)minBinlogFileName, (String)startSearchBinlogFile)) {
                        shouldBreak = true;
                        this.logger.warn("Didn't find the corresponding binlog files from {} to {}", (Object)minBinlogFileName, (Object)maxBinlogFileName);
                        continue;
                    }
                    binlogSeqNum = Integer.parseInt(startSearchBinlogFile.substring(startSearchBinlogFile.indexOf(".") + 1));
                    if (binlogSeqNum <= 1) {
                        this.logger.warn("Didn't find the corresponding binlog files");
                        shouldBreak = true;
                        continue;
                    }
                    nextBinlogSeqNum = binlogSeqNum - 1;
                    binlogFileNamePrefix = startSearchBinlogFile.substring(0, startSearchBinlogFile.indexOf(".") + 1);
                    binlogFileNameSuffix = String.format("%06d", nextBinlogSeqNum);
                    startSearchBinlogFile = binlogFileNamePrefix + binlogFileNameSuffix;
                    continue;
                }
                this.logger.info("found and return:{} in findByStartTimeStamp operation.", (Object)entryPosition);
                return entryPosition;
            }
            catch (Exception e) {
                this.logger.warn(String.format("the binlogfile:%s doesn't exist, to continue to search the next binlogfile , caused by", startSearchBinlogFile), (Throwable)e);
                binlogSeqNum = Integer.parseInt(startSearchBinlogFile.substring(startSearchBinlogFile.indexOf(".") + 1));
                if (binlogSeqNum <= 1) {
                    this.logger.warn("Didn't find the corresponding binlog files");
                    shouldBreak = true;
                    continue;
                }
                nextBinlogSeqNum = binlogSeqNum - 1;
                binlogFileNamePrefix = startSearchBinlogFile.substring(0, startSearchBinlogFile.indexOf(".") + 1);
                binlogFileNameSuffix = String.format("%06d", nextBinlogSeqNum);
                startSearchBinlogFile = binlogFileNamePrefix + binlogFileNameSuffix;
            }
        }
        return null;
    }

    private Long findServerId(MysqlConnection mysqlConnection) {
        try {
            ResultSetPacket packet = mysqlConnection.query("show variables like 'server_id'");
            List fields = packet.getFieldValues();
            if (CollectionUtils.isEmpty((Collection)fields)) {
                throw new CanalParseException("command : show variables like 'server_id' has an error! pls check. you need (at least one of) the SUPER,REPLICATION CLIENT privilege(s) for this operation");
            }
            return Long.valueOf((String)fields.get(1));
        }
        catch (IOException e) {
            throw new CanalParseException("command : show variables like 'server_id' has an error!", e);
        }
    }

    private EntryPosition findEndPosition(MysqlConnection mysqlConnection) {
        try {
            ResultSetPacket gtidPacket;
            List gtidFields;
            String showSql = this.multiStreamEnable ? "show master status with " + this.destination : "show master status";
            ResultSetPacket packet = mysqlConnection.query(showSql);
            List fields = packet.getFieldValues();
            if (CollectionUtils.isEmpty((Collection)fields)) {
                throw new CanalParseException("command : 'show master status' has an error! pls check. you need (at least one of) the SUPER,REPLICATION CLIENT privilege(s) for this operation");
            }
            EntryPosition endPosition = new EntryPosition((String)fields.get(0), Long.valueOf((String)fields.get(1)));
            if (this.isGTIDMode() && fields.size() > 4) {
                endPosition.setGtid((String)fields.get(4));
            }
            if (mysqlConnection.isMariaDB() && this.isGTIDMode() && !CollectionUtils.isEmpty((Collection)(gtidFields = (gtidPacket = mysqlConnection.query("SELECT @@global.gtid_binlog_pos")).getFieldValues())) && gtidFields.size() > 0) {
                endPosition.setGtid((String)gtidFields.get(0));
            }
            return endPosition;
        }
        catch (IOException e) {
            throw new CanalParseException("command : 'show master status' has an error!", e);
        }
    }

    private EntryPosition findStartPosition(MysqlConnection mysqlConnection) {
        try {
            String showSql = this.multiStreamEnable ? "show binlog events with " + this.destination + " limit 1" : "show binlog events limit 1";
            ResultSetPacket packet = mysqlConnection.query(showSql);
            List fields = packet.getFieldValues();
            if (CollectionUtils.isEmpty((Collection)fields)) {
                throw new CanalParseException("command : 'show binlog events limit 1' has an error! pls check. you need (at least one of) the SUPER,REPLICATION CLIENT privilege(s) for this operation");
            }
            EntryPosition endPosition = new EntryPosition((String)fields.get(0), Long.valueOf((String)fields.get(1)));
            return endPosition;
        }
        catch (IOException e) {
            throw new CanalParseException("command : 'show binlog events limit 1' has an error!", e);
        }
    }

    private SlaveEntryPosition findSlavePosition(MysqlConnection mysqlConnection) {
        try {
            ResultSetPacket packet = mysqlConnection.query("show slave status");
            List names = packet.getFieldDescriptors();
            List fields = packet.getFieldValues();
            if (CollectionUtils.isEmpty((Collection)fields)) {
                return null;
            }
            int i = 0;
            HashMap maps = new HashMap(names.size(), 1.0f);
            for (FieldPacket name : names) {
                maps.put(name.getName(), fields.get(i));
                ++i;
            }
            String errno = (String)maps.get("Last_Errno");
            String slaveIORunning = (String)maps.get("Slave_IO_Running");
            String slaveSQLRunning = (String)maps.get("Slave_SQL_Running");
            if (!("0".equals(errno) && "Yes".equalsIgnoreCase(slaveIORunning) && "Yes".equalsIgnoreCase(slaveSQLRunning))) {
                this.logger.warn("Ignoring failed slave: " + mysqlConnection.getConnector().getAddress() + ", Last_Errno = " + errno + ", Slave_IO_Running = " + slaveIORunning + ", Slave_SQL_Running = " + slaveSQLRunning);
                return null;
            }
            String masterHost = (String)maps.get("Master_Host");
            String masterPort = (String)maps.get("Master_Port");
            String binlog = (String)maps.get("Master_Log_File");
            String position = (String)maps.get("Exec_Master_Log_Pos");
            return new SlaveEntryPosition(binlog, Long.valueOf(position), masterHost, masterPort);
        }
        catch (IOException e) {
            this.logger.error("find slave position error", (Throwable)e);
            return null;
        }
    }

    private EntryPosition findAsPerTimestampInSpecificLogFile(MysqlConnection mysqlConnection, final Long startTimestamp, final EntryPosition endPosition, final String searchBinlogFile, final Boolean justForPositionTimestamp) {
        final LogPosition logPosition = new LogPosition();
        try {
            mysqlConnection.reconnect();
            mysqlConnection.seek(searchBinlogFile, 4L, endPosition.getGtid(), new SinkFunction<LogEvent>(){
                private LogPosition lastPosition;

                @Override
                public boolean sink(LogEvent event) {
                    EntryPosition entryPosition = null;
                    try {
                        CanalEntry.Entry entry = MysqlEventParser.this.parseAndProfilingIfNecessary(event, true);
                        if (justForPositionTimestamp.booleanValue() && logPosition.getPostion() == null && event.getWhen() > 0L) {
                            entryPosition = new EntryPosition(searchBinlogFile, Long.valueOf(event.getLogPos() - (long)event.getEventLen()), Long.valueOf(event.getWhen() * 1000L), Long.valueOf(event.getServerId()));
                            entryPosition.setGtid(event.getHeader().getGtidSetStr());
                            logPosition.setPostion(entryPosition);
                        }
                        String logfilename = event.getHeader().getLogFileName();
                        Long logfileoffset = event.getHeader().getLogPos();
                        Long logposTimestamp = event.getHeader().getWhen() * 1000L;
                        Long serverId = event.getHeader().getServerId();
                        if (logposTimestamp >= startTimestamp) {
                            return false;
                        }
                        if (StringUtils.equals((String)endPosition.getJournalName(), (String)logfilename) && endPosition.getPosition() <= logfileoffset) {
                            return false;
                        }
                        if (entry == null) {
                            return true;
                        }
                        if (CanalEntry.EntryType.TRANSACTIONEND.equals((Object)entry.getEntryType())) {
                            entryPosition = new EntryPosition(logfilename, logfileoffset, logposTimestamp, serverId);
                            if (MysqlEventParser.this.logger.isDebugEnabled()) {
                                MysqlEventParser.this.logger.debug("set {} to be pending start position before finding another proper one...", (Object)entryPosition);
                            }
                            logPosition.setPostion(entryPosition);
                            entryPosition.setGtid(entry.getHeader().getGtid());
                        } else if (CanalEntry.EntryType.TRANSACTIONBEGIN.equals((Object)entry.getEntryType())) {
                            entryPosition = new EntryPosition(logfilename, logfileoffset, logposTimestamp, serverId);
                            if (MysqlEventParser.this.logger.isDebugEnabled()) {
                                MysqlEventParser.this.logger.debug("set {} to be pending start position before finding another proper one...", (Object)entryPosition);
                            }
                            entryPosition.setGtid(entry.getHeader().getGtid());
                            logPosition.setPostion(entryPosition);
                        }
                        this.lastPosition = MysqlEventParser.this.buildLastPosition(entry);
                    }
                    catch (Throwable e) {
                        MysqlEventParser.this.processSinkError(e, this.lastPosition, searchBinlogFile, 4L);
                    }
                    return MysqlEventParser.this.running;
                }
            });
        }
        catch (IOException e) {
            this.logger.error("ERROR ## findAsPerTimestampInSpecificLogFile has an error", (Throwable)e);
        }
        if (logPosition.getPostion() != null) {
            return logPosition.getPostion();
        }
        return null;
    }

    @Override
    protected void processDumpError(Throwable e) {
        String message;
        if (e instanceof IOException && StringUtils.contains((String)(message = e.getMessage()), (String)"errno = 1236")) {
            ++this.dumpErrorCount;
        }
        super.processDumpError(e);
    }

    public void setSupportBinlogFormats(String formatStrs) {
        String[] formats = StringUtils.split((String)formatStrs, (char)',');
        if (formats != null) {
            MysqlConnection.BinlogFormat[] supportBinlogFormats = new MysqlConnection.BinlogFormat[formats.length];
            int i = 0;
            for (String format : formats) {
                supportBinlogFormats[i++] = MysqlConnection.BinlogFormat.valuesOf(format);
            }
            this.supportBinlogFormats = supportBinlogFormats;
        }
    }

    public void setSupportBinlogImages(String imageStrs) {
        String[] images = StringUtils.split((String)imageStrs, (char)',');
        if (images != null) {
            MysqlConnection.BinlogImage[] supportBinlogImages = new MysqlConnection.BinlogImage[images.length];
            int i = 0;
            for (String image : images) {
                supportBinlogImages[i++] = MysqlConnection.BinlogImage.valuesOf(image);
            }
            this.supportBinlogImages = supportBinlogImages;
        }
    }

    public void setDefaultConnectionTimeoutInSeconds(int defaultConnectionTimeoutInSeconds) {
        this.defaultConnectionTimeoutInSeconds = defaultConnectionTimeoutInSeconds;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public void setMasterInfo(AuthenticationInfo masterInfo) {
        this.masterInfo = masterInfo;
    }

    public void setStandbyInfo(AuthenticationInfo standbyInfo) {
        this.standbyInfo = standbyInfo;
    }

    public void setMasterPosition(EntryPosition masterPosition) {
        this.masterPosition = masterPosition;
    }

    public void setStandbyPosition(EntryPosition standbyPosition) {
        this.standbyPosition = standbyPosition;
    }

    public void setSlaveId(long slaveId) {
        this.slaveId = slaveId;
    }

    public void setDetectingSQL(String detectingSQL) {
        this.detectingSQL = detectingSQL;
    }

    @Override
    public void setDetectingIntervalInSeconds(Integer detectingIntervalInSeconds) {
        this.detectingIntervalInSeconds = detectingIntervalInSeconds;
    }

    @Override
    public void setDetectingEnable(boolean detectingEnable) {
        this.detectingEnable = detectingEnable;
    }

    public void setFallbackIntervalInSeconds(int fallbackIntervalInSeconds) {
        this.fallbackIntervalInSeconds = fallbackIntervalInSeconds;
    }

    public CanalHAController getHaController() {
        return this.haController;
    }

    public void setHaController(CanalHAController haController) {
        this.haController = haController;
    }

    public void setDumpErrorCountThreshold(int dumpErrorCountThreshold) {
        this.dumpErrorCountThreshold = dumpErrorCountThreshold;
    }

    public boolean isRdsOssMode() {
        return this.rdsOssMode;
    }

    public void setRdsOssMode(boolean rdsOssMode) {
        this.rdsOssMode = rdsOssMode;
    }

    public void setDumpErrorCount(int dumpErrorCount) {
        this.dumpErrorCount = dumpErrorCount;
    }

    public boolean isAutoResetLatestPosMode() {
        return this.autoResetLatestPosMode;
    }

    public void setAutoResetLatestPosMode(boolean autoResetLatestPosMode) {
        this.autoResetLatestPosMode = autoResetLatestPosMode;
    }

    public void setMultiStreamEnable(boolean multiStreamEnable) {
        this.multiStreamEnable = multiStreamEnable;
    }

    class MysqlDetectingTimeTask
    extends TimerTask {
        private boolean reconnect = false;
        private MysqlConnection mysqlConnection;

        public MysqlDetectingTimeTask(MysqlConnection mysqlConnection) {
            this.mysqlConnection = mysqlConnection;
        }

        @Override
        public void run() {
            try {
                if (this.reconnect) {
                    this.reconnect = false;
                    this.mysqlConnection.reconnect();
                } else if (!this.mysqlConnection.isConnected()) {
                    this.mysqlConnection.connect();
                }
                long startTime = System.currentTimeMillis();
                if (StringUtils.startsWithIgnoreCase((String)MysqlEventParser.this.detectingSQL.trim(), (String)"select") || StringUtils.startsWithIgnoreCase((String)MysqlEventParser.this.detectingSQL.trim(), (String)"show") || StringUtils.startsWithIgnoreCase((String)MysqlEventParser.this.detectingSQL.trim(), (String)"explain") || StringUtils.startsWithIgnoreCase((String)MysqlEventParser.this.detectingSQL.trim(), (String)"desc")) {
                    this.mysqlConnection.query(MysqlEventParser.this.detectingSQL);
                } else {
                    this.mysqlConnection.update(MysqlEventParser.this.detectingSQL);
                }
                long costTime = System.currentTimeMillis() - startTime;
                if (MysqlEventParser.this.haController != null && MysqlEventParser.this.haController instanceof HeartBeatCallback) {
                    ((HeartBeatCallback)((Object)MysqlEventParser.this.haController)).onSuccess(costTime);
                }
            }
            catch (Throwable e) {
                if (MysqlEventParser.this.haController != null && MysqlEventParser.this.haController instanceof HeartBeatCallback) {
                    ((HeartBeatCallback)((Object)MysqlEventParser.this.haController)).onFailed(e);
                }
                this.reconnect = true;
                MysqlEventParser.this.logger.warn("connect failed by ", e);
            }
        }

        public MysqlConnection getMysqlConnection() {
            return this.mysqlConnection;
        }
    }
}

