/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.tsdb.dao;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.mybatis.spring.support.SqlSessionDaoSupport;

public class MetaBaseDAO
extends SqlSessionDaoSupport {
    protected boolean isH2 = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initTable(String tableName) throws Exception {
        block11: {
            InputStream input;
            Connection conn;
            block10: {
                conn = null;
                input = null;
                DataSource dataSource = this.getSqlSessionFactory().getConfiguration().getEnvironment().getDataSource();
                conn = dataSource.getConnection();
                String name = "mysql";
                this.isH2 = this.isH2(conn);
                if (this.isH2) {
                    name = "h2";
                }
                if ((input = Thread.currentThread().getContextClassLoader().getResourceAsStream("ddl/" + name + "/" + tableName + ".sql")) != null) break block10;
                IOUtils.closeQuietly((InputStream)input);
                if (conn != null) {
                    conn.close();
                }
                return;
            }
            try {
                String sql = StringUtils.join((Collection)IOUtils.readLines((InputStream)input), (String)"\n");
                Statement stmt = conn.createStatement();
                stmt.execute(sql);
                stmt.close();
            }
            catch (Throwable e) {
                try {
                    this.logger.warn((Object)("init " + tableName + " failed"), e);
                    break block11;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtils.closeQuietly(input);
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)input);
            if (conn != null) {
                conn.close();
            }
        }
    }

    private boolean isH2(Connection conn) throws SQLException {
        String product = conn.getMetaData().getDatabaseProductName();
        return StringUtils.containsIgnoreCase((String)product, (String)"H2");
    }
}

