/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.admin.netty;

import com.alibaba.otter.canal.protocol.AdminPacket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.CompositeChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.Channels;

public class AdminNettyUtils {
    public static int HEADER_LENGTH = 4;
    public static int VERSION = 1;

    public static void write(Channel channel, ByteBuffer body) {
        byte[] header = ByteBuffer.allocate(HEADER_LENGTH).order(ByteOrder.BIG_ENDIAN).putInt(body.limit()).array();
        ArrayList<ChannelBuffer> components = new ArrayList<ChannelBuffer>(2);
        components.add(ChannelBuffers.wrappedBuffer((ByteOrder)ByteOrder.BIG_ENDIAN, (byte[])header));
        components.add(ChannelBuffers.wrappedBuffer((ByteBuffer)body));
        Channels.write((Channel)channel, (Object)new CompositeChannelBuffer(ByteOrder.BIG_ENDIAN, components));
    }

    public static void write(Channel channel, byte[] body) {
        byte[] header = ByteBuffer.allocate(HEADER_LENGTH).order(ByteOrder.BIG_ENDIAN).putInt(body.length).array();
        Channels.write((Channel)channel, (Object)ChannelBuffers.wrappedBuffer((byte[][])new byte[][]{header, body}));
    }

    public static void write(Channel channel, byte[] body, ChannelFutureListener channelFutureListner) {
        byte[] header = ByteBuffer.allocate(HEADER_LENGTH).order(ByteOrder.BIG_ENDIAN).putInt(body.length).array();
        Channels.write((Channel)channel, (Object)ChannelBuffers.wrappedBuffer((byte[][])new byte[][]{header, body})).addListener(channelFutureListner);
    }

    public static byte[] ackPacket() {
        return AdminNettyUtils.ackPacket(null);
    }

    public static byte[] ackPacket(String message) {
        return AdminPacket.Packet.newBuilder().setType(AdminPacket.PacketType.ACK).setVersion(VERSION).setBody(AdminPacket.Ack.newBuilder().setCode(0).setMessage(message == null ? "" : message).build().toByteString()).build().toByteArray();
    }

    public static byte[] errorPacket(int errorCode, String errorMessage) {
        return AdminPacket.Packet.newBuilder().setType(AdminPacket.PacketType.ACK).setVersion(VERSION).setBody(AdminPacket.Ack.newBuilder().setCode(errorCode).setMessage(errorMessage).build().toByteString()).build().toByteArray();
    }
}

