/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.server.netty;

import com.alibaba.otter.canal.protocol.CanalPacket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.buffer.CompositeChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyUtils {
    private static final Logger logger = LoggerFactory.getLogger(NettyUtils.class);
    public static int HEADER_LENGTH = 4;
    public static Timer hashedWheelTimer = new HashedWheelTimer();
    public static int VERSION = 1;

    public static void write(Channel channel, ByteBuffer body, ChannelFutureListener channelFutureListner) {
        byte[] header = ByteBuffer.allocate(HEADER_LENGTH).order(ByteOrder.BIG_ENDIAN).putInt(body.limit()).array();
        ArrayList<ChannelBuffer> components = new ArrayList<ChannelBuffer>(2);
        components.add(ChannelBuffers.wrappedBuffer((ByteOrder)ByteOrder.BIG_ENDIAN, (byte[])header));
        components.add(ChannelBuffers.wrappedBuffer((ByteBuffer)body));
        if (channelFutureListner == null) {
            Channels.write((Channel)channel, (Object)new CompositeChannelBuffer(ByteOrder.BIG_ENDIAN, components));
        } else {
            Channels.write((Channel)channel, (Object)new CompositeChannelBuffer(ByteOrder.BIG_ENDIAN, components)).addListener(channelFutureListner);
        }
    }

    public static void write(Channel channel, byte[] body, ChannelFutureListener channelFutureListner) {
        byte[] header = ByteBuffer.allocate(HEADER_LENGTH).order(ByteOrder.BIG_ENDIAN).putInt(body.length).array();
        if (channelFutureListner == null) {
            Channels.write((Channel)channel, (Object)ChannelBuffers.wrappedBuffer((byte[][])new byte[][]{header, body}));
        } else {
            Channels.write((Channel)channel, (Object)ChannelBuffers.wrappedBuffer((byte[][])new byte[][]{header, body})).addListener(channelFutureListner);
        }
    }

    public static void ack(Channel channel, ChannelFutureListener channelFutureListner) {
        NettyUtils.write(channel, CanalPacket.Packet.newBuilder().setType(CanalPacket.PacketType.ACK).setVersion(VERSION).setBody(CanalPacket.Ack.newBuilder().build().toByteString()).build().toByteArray(), channelFutureListner);
    }

    public static void error(int errorCode, String errorMessage, Channel channel, ChannelFutureListener channelFutureListener) {
        if (channelFutureListener == null) {
            channelFutureListener = ChannelFutureListener.CLOSE;
        }
        logger.error("ErrotCode:{} , Caused by : \n{}", (Object)errorCode, (Object)errorMessage);
        NettyUtils.write(channel, CanalPacket.Packet.newBuilder().setType(CanalPacket.PacketType.ACK).setVersion(VERSION).setBody(CanalPacket.Ack.newBuilder().setErrorCode(errorCode).setErrorMessage(errorMessage).build().toByteString()).build().toByteArray(), channelFutureListener);
    }

    public static byte[] ackPacket() {
        return CanalPacket.Packet.newBuilder().setType(CanalPacket.PacketType.ACK).setVersion(VERSION).setBody(CanalPacket.Ack.newBuilder().build().toByteString()).build().toByteArray();
    }

    public static byte[] errorPacket(int errorCode, String errorMessage) {
        return CanalPacket.Packet.newBuilder().setType(CanalPacket.PacketType.ACK).setVersion(VERSION).setBody(CanalPacket.Ack.newBuilder().setErrorCode(errorCode).setErrorMessage(errorMessage).build().toByteString()).build().toByteArray();
    }
}

