/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.server.netty.handler;

import com.alibaba.otter.canal.protocol.CanalPacket;
import com.alibaba.otter.canal.server.netty.NettyUtils;
import com.alibaba.otter.canal.server.netty.handler.ClientAuthenticationHandler;
import com.google.protobuf.ByteString;
import org.apache.commons.lang3.RandomUtils;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandshakeInitializationHandler
extends SimpleChannelHandler {
    private ChannelGroup childGroups;
    private static final Logger logger = LoggerFactory.getLogger(HandshakeInitializationHandler.class);

    public HandshakeInitializationHandler(ChannelGroup childGroups) {
        this.childGroups = childGroups;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.childGroups != null) {
            this.childGroups.add((Object)ctx.getChannel());
        }
        byte[] seed = RandomUtils.nextBytes((int)8);
        byte[] body = CanalPacket.Packet.newBuilder().setType(CanalPacket.PacketType.HANDSHAKE).setVersion(NettyUtils.VERSION).setBody(CanalPacket.Handshake.newBuilder().setSeeds(ByteString.copyFrom((byte[])seed)).build().toByteString()).build().toByteArray();
        NettyUtils.write(ctx.getChannel(), body, future -> {
            ctx.getPipeline().get(HandshakeInitializationHandler.class.getName());
            ClientAuthenticationHandler handler = (ClientAuthenticationHandler)ctx.getPipeline().get(ClientAuthenticationHandler.class.getName());
            handler.setSeed(seed);
        });
        logger.info("send handshake initialization packet to : {}", (Object)ctx.getChannel());
    }
}

