/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.concurrent;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.AbstractTimer;
import io.pravega.common.Exceptions;
import io.pravega.common.Timer;
import io.pravega.common.concurrent.Futures;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedProcessor<T extends Item>
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DelayedProcessor.class);
    private final Function<T, CompletableFuture<Void>> itemProcessor;
    private final Duration itemDelay;
    private final ScheduledExecutorService executor;
    @VisibleForTesting
    private final AbstractTimer timer;
    private final DelayedQueue queue;
    private final CompletableFuture<Void> runTask;
    private volatile CompletableFuture<Void> currentIterationDelayTask;
    private final AtomicBoolean closed;
    private final String traceObjectId;

    public DelayedProcessor(Function<T, CompletableFuture<Void>> itemProcessor, Duration itemDelay, ScheduledExecutorService executor, String traceObjectId) {
        this.itemProcessor = itemProcessor;
        this.itemDelay = itemDelay;
        this.executor = executor;
        this.traceObjectId = traceObjectId;
        this.closed = new AtomicBoolean(false);
        this.timer = new Timer();
        this.queue = new DelayedQueue();
        this.runTask = this.start();
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.runTask.cancel(true);
            CompletableFuture<Void> delayTask = this.currentIterationDelayTask;
            if (delayTask != null) {
                delayTask.cancel(true);
            }
            this.queue.clear();
            log.info("{}: Closed.", (Object)this.traceObjectId);
        }
    }

    public void process(@NonNull T item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        Exceptions.checkNotClosed(this.closed.get(), this);
        this.queue.add(item);
    }

    public void cancel(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Exceptions.checkNotClosed(this.closed.get(), this);
        this.queue.remove(key);
    }

    @VisibleForTesting
    int size() {
        return this.queue.size();
    }

    private CompletableFuture<Void> start() {
        log.info("{}: Started. Iteration Delay = {} ms.", (Object)this.traceObjectId, (Object)this.itemDelay.toMillis());
        return Futures.loop(() -> !this.closed.get(), () -> this.delay().thenComposeAsync(v -> this.runOneIteration(), (Executor)this.executor), (Executor)this.executor);
    }

    private CompletableFuture<Void> runOneIteration() {
        if (this.closed.get()) {
            log.debug("{}: Not running iteration due to shutting down.", (Object)this.traceObjectId);
            return CompletableFuture.completedFuture(null);
        }
        QueueItem firstItem = this.queue.peekFirst();
        if (firstItem == null || firstItem.getRemainingMillis() > 0L) {
            log.warn("{}: Not running iteration due premature wake-up.", (Object)this.traceObjectId);
            return CompletableFuture.completedFuture(null);
        }
        return this.itemProcessor.apply(firstItem.getWrappedItem()).handle((r, ex) -> {
            if (ex != null) {
                log.error("{}: Unable to process {}.", new Object[]{this.traceObjectId, firstItem, ex});
            }
            this.queue.removeFirstIf(firstItem);
            return null;
        });
    }

    private CompletableFuture<Void> delay() {
        Duration delay = this.calculateDelay();
        log.debug("{}: Iteration delay = {} ms. Queue size = {}.", new Object[]{this.traceObjectId, delay.toMillis(), this.queue.size()});
        CompletionStage result = this.createDelayedFuture(delay).whenCompleteAsync((r, ex) -> {
            this.currentIterationDelayTask = null;
        }, (Executor)this.executor);
        this.currentIterationDelayTask = result;
        return result;
    }

    @VisibleForTesting
    protected CompletableFuture<Void> createDelayedFuture(Duration delay) {
        return Futures.delayedFuture(delay, this.executor);
    }

    private Duration calculateDelay() {
        QueueItem firstItem = this.queue.peekFirst();
        Duration firstItemDuration = firstItem == null ? this.itemDelay : Duration.ofMillis(firstItem.getRemainingMillis());
        return firstItemDuration.compareTo(this.itemDelay) < 0 ? firstItemDuration : this.itemDelay;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    AbstractTimer getTimer() {
        return this.timer;
    }

    public static interface Item {
        public String key();
    }

    private static class QueueItem {
        private final T wrappedItem;
        private final long addedTime;
        private final long expirationTime;
        final /* synthetic */ DelayedProcessor this$0;

        QueueItem(T wrappedItem) {
            this.this$0 = var1_1;
            this.wrappedItem = wrappedItem;
            this.addedTime = var1_1.getTimer().getElapsedMillis();
            this.expirationTime = this.addedTime + ((DelayedProcessor)var1_1).itemDelay.toMillis();
        }

        long getRemainingMillis() {
            return Math.max(0L, this.expirationTime - this.this$0.getTimer().getElapsedMillis());
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public T getWrappedItem() {
            return this.wrappedItem;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getAddedTime() {
            return this.addedTime;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getExpirationTime() {
            return this.expirationTime;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "DelayedProcessor.QueueItem(wrappedItem=" + this.getWrappedItem() + ", addedTime=" + this.getAddedTime() + ", expirationTime=" + this.getExpirationTime() + ")";
        }
    }

    private class DelayedQueue {
        @GuardedBy(value="this")
        private final Set<String> keys = new HashSet<String>();
        @GuardedBy(value="this")
        private final Deque<QueueItem> queue = new ArrayDeque<QueueItem>();

        private DelayedQueue() {
        }

        synchronized void clear() {
            this.keys.clear();
            this.queue.clear();
        }

        synchronized int size() {
            return this.queue.size();
        }

        synchronized void add(T item) {
            if (this.keys.add(item.key())) {
                this.queue.add(new QueueItem(DelayedProcessor.this, item));
            }
        }

        synchronized void remove(String key) {
            this.keys.remove(key);
            this.queue.removeIf(i -> i.getWrappedItem().key().equals(key));
        }

        synchronized QueueItem peekFirst() {
            return this.queue.peekFirst();
        }

        synchronized void removeFirstIf(QueueItem firstItem) {
            QueueItem item = this.queue.pollFirst();
            if (item != firstItem) {
                this.queue.addFirst(item);
                return;
            }
            if (item != null) {
                this.keys.remove(item.getWrappedItem().key());
            }
        }
    }
}

