/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.io;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.io.SerializationException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;

@NotThreadSafe
public class BoundedInputStream
extends FilterInputStream {
    private final int bound;
    private int remaining;

    public BoundedInputStream(InputStream inputStream, int bound) {
        super(inputStream);
        Preconditions.checkArgument((bound >= 0 ? 1 : 0) != 0, (Object)"bound must be a non-negative integer.");
        this.bound = bound;
        this.remaining = bound;
    }

    @Override
    public void close() throws IOException {
        if (this.remaining > 0) {
            int toSkip = this.remaining;
            long skipped = this.skip(toSkip);
            if (skipped != (long)toSkip) {
                throw new SerializationException(String.format("Read %d fewer byte(s) than expected only able to skip %d.", toSkip, skipped));
            }
        } else if (this.remaining < 0) {
            throw new SerializationException(String.format("Read more bytes than expected (%d).", -this.remaining));
        }
    }

    @Override
    public int read() throws IOException {
        int r;
        int n = r = this.remaining > 0 ? this.in.read() : -1;
        if (r >= 0) {
            --this.remaining;
        }
        return r;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int readLength = Math.min(length, this.remaining);
        int r = this.in.read(buffer, offset, readLength);
        if (r > 0) {
            this.remaining -= r;
        } else if (length > 0 && this.remaining <= 0) {
            return -1;
        }
        return r;
    }

    @Override
    public long skip(long count) throws IOException {
        long r = this.in.skip(Math.min(count, (long)this.remaining));
        this.remaining = (int)((long)this.remaining - r);
        return r;
    }

    @Override
    public int available() throws IOException {
        return Math.min(this.in.available(), this.remaining);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public BoundedInputStream subStream(int bound) {
        Preconditions.checkArgument((bound >= 0 && bound <= this.remaining ? 1 : 0) != 0, (Object)"bound must be a non-negative integer and less than or equal to the remaining length.");
        this.remaining -= bound;
        return new BoundedInputStream(this.in, bound);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getBound() {
        return this.bound;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getRemaining() {
        return this.remaining;
    }
}

