/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.hash.HashHelper;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.BitConverter;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.common.util.ByteBufferUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import lombok.Generated;

public abstract class AbstractBufferView
implements BufferView {
    static final BufferView EMPTY = new EmptyBufferView();
    private static final HashHelper HASH = HashHelper.seededWith(AbstractBufferView.class.getName());

    public static int hashCode(byte[] array) {
        HashHelper.HashBuilder builder = HASH.newBuilder();
        builder.put(ByteBuffer.wrap(array));
        return builder.getAsInt();
    }

    public int hashCode() {
        HashHelper.HashBuilder builder = HASH.newBuilder();
        this.collect(builder::put);
        return builder.getAsInt();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BufferView) {
            return this.equals((BufferView)obj);
        }
        return false;
    }

    public boolean equals(BufferView other) {
        int l = this.getLength();
        if (l != other.getLength()) {
            return false;
        }
        if (l == 0) {
            return true;
        }
        Iterator<ByteBuffer> i1 = this.iterateBuffers();
        Iterator<ByteBuffer> i2 = other.iterateBuffers();
        ByteBuffer b1 = i1.next();
        ByteBuffer b2 = i2.next();
        while (b1 != null && b2 != null) {
            boolean equals;
            int lengthDiff = b1.remaining() - b2.remaining();
            if (lengthDiff == 0) {
                equals = b1.equals(b2);
                b1 = null;
                b2 = null;
            } else if (lengthDiff < 0) {
                equals = b1.equals(ByteBufferUtils.slice(b2, b2.position(), b1.remaining()));
                b1 = null;
                b2.position(b2.limit() + lengthDiff);
            } else {
                equals = b2.equals(ByteBufferUtils.slice(b1, b1.position(), b2.remaining()));
                b1.position(b1.limit() - lengthDiff);
                b2 = null;
            }
            if (!equals) {
                return false;
            }
            if (b1 == null && i1.hasNext()) {
                b1 = i1.next();
            }
            if (b2 != null || !i2.hasNext()) continue;
            b2 = i2.next();
        }
        assert (b1 == null && b2 == null);
        return true;
    }

    private static class EmptyBufferView
    extends AbstractBufferView {
        private final BufferView.Reader bufferViewReader = new EmptyReader();
        private final InputStream reader = new EmptyInputStream();

        private EmptyBufferView() {
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public int getAllocatedLength() {
            return 0;
        }

        @Override
        public InputStream getReader(int offset, int length) {
            return this.slice(offset, length).getReader();
        }

        @Override
        public BufferView slice(int offset, int length) {
            if (offset != 0 || length != 0) {
                throw new IndexOutOfBoundsException("Cannot slice empty BufferView.");
            }
            return this;
        }

        @Override
        public byte[] getCopy() {
            return new byte[0];
        }

        @Override
        public void copyTo(OutputStream target) {
        }

        @Override
        public int copyTo(ByteBuffer byteBuffer) {
            return 0;
        }

        @Override
        public <ExceptionT extends Exception> void collect(BufferView.Collector<ExceptionT> bufferCollector) {
        }

        @Override
        public Iterator<ByteBuffer> iterateBuffers() {
            return Collections.emptyIterator();
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BufferView.Reader getBufferViewReader() {
            return this.bufferViewReader;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public InputStream getReader() {
            return this.reader;
        }

        private static class EmptyReader
        extends AbstractReader {
            private EmptyReader() {
            }

            @Override
            public int available() {
                return 0;
            }

            @Override
            public int readBytes(ByteBuffer byteBuffer) {
                return 0;
            }

            @Override
            public byte readByte() {
                throw new BufferView.Reader.OutOfBoundsException("Cannot read from Empty BufferView.");
            }

            @Override
            public BufferView readSlice(int length) {
                if (length == 0) {
                    return BufferView.empty();
                }
                throw new BufferView.Reader.OutOfBoundsException("Cannot read from Empty BufferView.");
            }
        }

        private static class EmptyInputStream
        extends InputStream {
            private EmptyInputStream() {
            }

            @Override
            public int read() throws IOException {
                return -1;
            }
        }
    }

    protected static abstract class AbstractReader
    implements BufferView.Reader {
        protected AbstractReader() {
        }

        @Override
        public int readInt() {
            return BitConverter.makeInt(this.readByte(), this.readByte(), this.readByte(), this.readByte());
        }

        @Override
        public long readLong() {
            return BitConverter.makeLong(this.readByte(), this.readByte(), this.readByte(), this.readByte(), this.readByte(), this.readByte(), this.readByte(), this.readByte());
        }

        @Override
        public ArrayView readFully(int bufferSize) {
            int readBytes;
            Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (Object)"bufferSize must be a positive integer.");
            ByteArraySegment readBuffer = new ByteArraySegment(new byte[this.available()]);
            for (int readOffset = 0; readOffset < readBuffer.getLength(); readOffset += readBytes) {
                int readLength = Math.min(this.available(), readBuffer.getLength() - readOffset);
                readBytes = this.readBytes(readBuffer.slice(readOffset, Math.min(bufferSize, readLength)).asByteBuffer());
            }
            assert (this.available() == 0);
            return readBuffer;
        }
    }
}

