/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.util.AbstractBufferView;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.BufferView;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;

public class ByteArraySegment
extends AbstractBufferView
implements ArrayView {
    private final ByteBuffer buffer;
    private final int length;

    public ByteArraySegment(byte[] array) {
        this(array, 0, array.length);
    }

    public ByteArraySegment(ByteBuffer buff) {
        this(buff.array(), buff.arrayOffset() + buff.position(), buff.remaining());
    }

    public ByteArraySegment(byte[] array, int startOffset, int length) {
        this.buffer = ByteBuffer.wrap(array, startOffset, length);
        this.buffer.position(startOffset);
        this.length = length;
    }

    @Override
    public int getAllocatedLength() {
        return this.array().length;
    }

    @Override
    public byte get(int index) {
        return this.buffer.get(this.buffer.position() + index);
    }

    @Override
    public short getShort(int index) {
        return this.buffer.getShort(this.buffer.position() + index);
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(this.buffer.position() + index);
    }

    @Override
    public long getLong(int index) {
        return this.buffer.getLong(this.buffer.position() + index);
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset() + this.buffer.position();
    }

    @Override
    public Reader getBufferViewReader() {
        return new Reader();
    }

    @Override
    public InputStream getReader() {
        return new ByteArrayInputStream(this.array(), this.arrayOffset(), this.length);
    }

    @Override
    public InputStream getReader(int offset, int length) {
        Exceptions.checkArrayRange(offset, length, this.length, "offset", "length");
        return new ByteArrayInputStream(this.array(), this.arrayOffset() + offset, length);
    }

    @Override
    public ByteArraySegment slice(int offset, int length) {
        Exceptions.checkArrayRange(offset, length, this.length, "offset", "length");
        return new ByteArraySegment(this.array(), this.arrayOffset() + offset, length);
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return this.buffer.duplicate();
    }

    @Override
    public byte[] getCopy() {
        byte[] buffer = new byte[this.length];
        System.arraycopy(this.array(), this.arrayOffset(), buffer, 0, this.length);
        return buffer;
    }

    @Override
    public void copyTo(byte[] target, int targetOffset, int length) {
        Preconditions.checkElementIndex((int)length, (int)(this.length + 1), (String)"length");
        Exceptions.checkArrayRange(targetOffset, length, target.length, "index", "values.length");
        System.arraycopy(this.array(), this.arrayOffset(), target, targetOffset, length);
    }

    @Override
    public int copyTo(ByteBuffer target) {
        int length = Math.min(this.length, target.remaining());
        target.put(this.array(), this.arrayOffset(), length);
        return length;
    }

    @Override
    public void copyTo(OutputStream stream) throws IOException {
        stream.write(this.array(), this.arrayOffset(), this.length);
    }

    @Override
    public boolean equals(BufferView other) {
        if (this.length != other.getLength()) {
            return false;
        }
        if (other instanceof ByteArraySegment) {
            return this.buffer.equals(((ByteArraySegment)other).buffer);
        }
        return super.equals(other);
    }

    @Override
    public <ExceptionT extends Exception> void collect(BufferView.Collector<ExceptionT> bufferCollector) throws ExceptionT {
        bufferCollector.accept(this.asByteBuffer());
    }

    @Override
    public Iterator<ByteBuffer> iterateBuffers() {
        return Iterators.singletonIterator((Object)this.asByteBuffer());
    }

    @Override
    public void set(int index, byte value) {
        this.buffer.put(this.buffer.position() + index, value);
    }

    @Override
    public void setShort(int index, short value) {
        this.buffer.putShort(this.buffer.position() + index, value);
    }

    @Override
    public void setInt(int index, int value) {
        this.buffer.putInt(this.buffer.position() + index, value);
    }

    @Override
    public void setLong(int index, long value) {
        this.buffer.putLong(this.buffer.position() + index, value);
    }

    public void copyFrom(ArrayView source, int targetOffset, int length) {
        Exceptions.checkArrayRange(targetOffset, length, this.length, "index", "values.length");
        Preconditions.checkElementIndex((int)length, (int)(source.getLength() + 1), (String)"length");
        System.arraycopy(source.array(), source.arrayOffset(), this.array(), this.buffer.position() + targetOffset, length);
    }

    public void copyFrom(ArrayView source, int sourceOffset, int targetOffset, int length) {
        Exceptions.checkArrayRange(sourceOffset, length, source.getLength(), "index", "values.length");
        Exceptions.checkArrayRange(targetOffset, length, this.length, "index", "values.length");
        Preconditions.checkElementIndex((int)length, (int)(source.getLength() + 1), (String)"length");
        System.arraycopy(source.array(), source.arrayOffset() + sourceOffset, this.array(), this.buffer.position() + targetOffset, length);
    }

    public String toString() {
        if (this.getLength() > 128) {
            return this.buffer.toString();
        }
        return String.format("{%s}", IntStream.range(0, this.length).boxed().map(i -> Byte.toString(this.get((int)i))).collect(Collectors.joining(",")));
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getLength() {
        return this.length;
    }

    private class Reader
    extends AbstractBufferView.AbstractReader
    implements BufferView.Reader {
        private int position = 0;

        private Reader() {
        }

        @Override
        public int available() {
            return ByteArraySegment.this.length - this.position;
        }

        @Override
        public int readBytes(ByteBuffer byteBuffer) {
            int len = Math.min(this.available(), byteBuffer.remaining());
            byteBuffer.put(ByteArraySegment.this.array(), ByteArraySegment.this.arrayOffset() + this.position, len);
            this.position += len;
            return len;
        }

        @Override
        public byte readByte() {
            if (this.position >= ByteArraySegment.this.length) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
            byte result = ByteArraySegment.this.get(this.position);
            ++this.position;
            return result;
        }

        @Override
        public int readInt() {
            int nextPos = this.position + 4;
            if (nextPos > ByteArraySegment.this.length) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
            int r = ByteArraySegment.this.getInt(this.position);
            this.position = nextPos;
            return r;
        }

        @Override
        public long readLong() {
            int nextPos = this.position + 8;
            if (nextPos > ByteArraySegment.this.length) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
            long r = ByteArraySegment.this.getLong(this.position);
            this.position = nextPos;
            return r;
        }

        @Override
        public BufferView readSlice(int length) {
            try {
                ByteArraySegment result = ByteArraySegment.this.slice(this.position, length);
                this.position += length;
                return result;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
        }
    }
}

