/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config.convert.converter;

import java.util.Objects;
import org.apache.eventmesh.common.config.convert.ConvertInfo;
import org.apache.eventmesh.common.config.convert.ConvertValue;

public class BaseDataTypeConverter {

    public static class DoubleConverter
    implements ConvertValue<Double> {
        @Override
        public Double convert(ConvertInfo convertInfo) {
            return Double.valueOf((String)convertInfo.getValue());
        }
    }

    public static class FloatConverter
    implements ConvertValue<Float> {
        @Override
        public Float convert(ConvertInfo convertInfo) {
            return Float.valueOf((String)convertInfo.getValue());
        }
    }

    public static class LongConverter
    implements ConvertValue<Long> {
        @Override
        public Long convert(ConvertInfo convertInfo) {
            return Long.valueOf((String)convertInfo.getValue());
        }
    }

    public static class IntegerConverter
    implements ConvertValue<Integer> {
        @Override
        public Integer convert(ConvertInfo convertInfo) {
            return Integer.valueOf((String)convertInfo.getValue());
        }
    }

    public static class ShortConverter
    implements ConvertValue<Short> {
        @Override
        public Short convert(ConvertInfo convertInfo) {
            return Short.valueOf((String)convertInfo.getValue());
        }
    }

    public static class ByteConverter
    implements ConvertValue<Byte> {
        @Override
        public Byte convert(ConvertInfo convertInfo) {
            return Byte.valueOf((String)convertInfo.getValue());
        }
    }

    public static class BooleanConverter
    implements ConvertValue<Boolean> {
        @Override
        public Boolean convert(ConvertInfo convertInfo) {
            String value = (String)convertInfo.getValue();
            if (value.length() == 1) {
                return Objects.equals(convertInfo.getValue(), "1") ? Boolean.TRUE : Boolean.FALSE;
            }
            return Boolean.valueOf((String)convertInfo.getValue());
        }
    }

    public static class CharacterConverter
    implements ConvertValue<Character> {
        @Override
        public Character convert(ConvertInfo convertInfo) {
            String value = (String)convertInfo.getValue();
            return Character.valueOf(value.charAt(0));
        }
    }
}

