/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.remote;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.eventmesh.common.remote.datasource.DataSourceType;

public enum TransportType {
    MYSQL_MYSQL(DataSourceType.MYSQL, DataSourceType.MYSQL),
    REDIS_REDIS(DataSourceType.REDIS, DataSourceType.REDIS),
    ROCKETMQ_ROCKETMQ(DataSourceType.ROCKETMQ, DataSourceType.ROCKETMQ),
    MYSQL_HTTP(DataSourceType.MYSQL, DataSourceType.HTTP),
    ROCKETMQ_HTTP(DataSourceType.ROCKETMQ, DataSourceType.HTTP),
    HTTP_MYSQL(DataSourceType.HTTP, DataSourceType.MYSQL),
    HTTP_REDIS(DataSourceType.HTTP, DataSourceType.REDIS),
    HTTP_ROCKETMQ(DataSourceType.HTTP, DataSourceType.ROCKETMQ),
    REDIS_MQ(DataSourceType.REDIS, DataSourceType.ROCKETMQ),
    HTTP_HTTP(DataSourceType.HTTP, DataSourceType.HTTP);

    private static final Map<String, TransportType> INDEX_TYPES;
    private static final TransportType[] TYPES;
    private static final String SEPARATOR = "@";
    private final DataSourceType src;
    private final DataSourceType dst;

    private TransportType(DataSourceType src, DataSourceType dst) {
        this.src = src;
        this.dst = dst;
    }

    public static TransportType getTransportType(String index) {
        if (index == null || index.isEmpty()) {
            return null;
        }
        return INDEX_TYPES.get(index);
    }

    public static TransportType getTransportType(Integer index) {
        if (index == null || index < 0 || index >= TYPES.length) {
            return null;
        }
        return TYPES[index];
    }

    @Generated
    public DataSourceType getSrc() {
        return this.src;
    }

    @Generated
    public DataSourceType getDst() {
        return this.dst;
    }

    static {
        INDEX_TYPES = new HashMap<String, TransportType>();
        for (TransportType type : TYPES = TransportType.values()) {
            INDEX_TYPES.put(type.name(), type);
        }
    }
}

