/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.config;

import com.navercorp.pinpoint.bootstrap.config.DumpType;
import com.navercorp.pinpoint.bootstrap.config.HttpStatusCodeErrors;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.TransportModule;
import com.navercorp.pinpoint.bootstrap.util.NumberUtils;
import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.config.Value;
import com.navercorp.pinpoint.common.config.util.BypassResolver;
import com.navercorp.pinpoint.common.config.util.ValueResolver;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.common.util.logger.CommonLogger;
import com.navercorp.pinpoint.common.util.logger.StdoutCommonLoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;

public class DefaultProfilerConfig
implements ProfilerConfig {
    public static final String PROFILER_INTERCEPTOR_EXCEPTION_PROPAGATE = "profiler.interceptor.exception.propagate";
    private static final CommonLogger logger = StdoutCommonLoggerFactory.INSTANCE.getLogger(DefaultProfilerConfig.class.getName());
    public static final String IMPORT_PLUGIN = "profiler.plugin.import-plugin";
    public static final String AGENT_CLASSLOADER_ADDITIONAL_LIBS = "profiler.agent.classloader.additional-libs";
    private final Properties properties;
    private static final TransportModule DEFAULT_TRANSPORT_MODULE = TransportModule.GRPC;
    @Value(value="${pinpoint.disable:false}")
    private String pinpointDisable = "false";
    @Value(value="${profiler.logdir.maxbackupsize}")
    private int logDirMaxBackupSize = 5;
    @Value(value="${pinpoint.profiler.profiles.active }")
    private String activeProfile = "";
    @VisibleForTesting
    private boolean staticResourceCleanup = false;
    private TransportModule transportModule = DEFAULT_TRANSPORT_MODULE;
    @Value(value="${profiler.jdbc.sqlcachesize}")
    private int jdbcSqlCacheSize = 1024;
    @Value(value="${profiler.jdbc.tracesqlbindvalue}")
    private boolean traceSqlBindValue = false;
    @Value(value="${profiler.jdbc.maxsqlbindvaluesize}")
    private int maxSqlBindValueSize = 1024;
    @Value(value="${profiler.transport.grpc.stats.logging.period}")
    private String grpcStatLoggingPeriod = "PT1M";
    private HttpStatusCodeErrors httpStatusCodeErrors = new HttpStatusCodeErrors();
    @Value(value="${profiler.guice.module.factory}")
    private String injectionModuleFactoryClazzName = null;
    @Value(value="${profiler.application.namespace}")
    private String applicationNamespace = "";
    @Value(value="${profiler.agent.classloader.additional-libs}")
    private String agentClassloaderAdditionalLibs = "";

    public DefaultProfilerConfig() {
        this.properties = new Properties();
    }

    DefaultProfilerConfig(Properties properties) {
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String getActiveProfile() {
        return this.activeProfile;
    }

    @Override
    public TransportModule getTransportModule() {
        return this.transportModule;
    }

    @Value(value="${profiler.transport.module}")
    public void setTransportModule(String transportModule) {
        this.transportModule = TransportModule.parse(transportModule, DEFAULT_TRANSPORT_MODULE);
    }

    @Override
    public String getPinpointDisable() {
        return this.pinpointDisable;
    }

    @Override
    public int getJdbcSqlCacheSize() {
        return this.jdbcSqlCacheSize;
    }

    @Override
    public boolean isTraceSqlBindValue() {
        return this.traceSqlBindValue;
    }

    @Override
    public int getMaxSqlBindValueSize() {
        return this.maxSqlBindValueSize;
    }

    @Override
    public String getGrpcStatLoggingPeriod() {
        return this.grpcStatLoggingPeriod;
    }

    @Override
    public boolean getStaticResourceCleanup() {
        return this.staticResourceCleanup;
    }

    @Override
    public HttpStatusCodeErrors getHttpStatusCodeErrors() {
        return this.httpStatusCodeErrors;
    }

    @Value(value="${profiler.http.status.code.errors}")
    void setHttpStatusCodeErrors(String httpStatusCodeErrors) {
        List httpStatusCodeErrorList = StringUtils.tokenizeToStringList((String)httpStatusCodeErrors, (String)",");
        this.httpStatusCodeErrors = new HttpStatusCodeErrors(httpStatusCodeErrorList);
    }

    @Override
    public String getInjectionModuleFactoryClazzName() {
        return this.injectionModuleFactoryClazzName;
    }

    @Override
    public String getApplicationNamespace() {
        return this.applicationNamespace;
    }

    @Override
    public int getLogDirMaxBackupSize() {
        return this.logDirMaxBackupSize;
    }

    @Override
    public List<String> getAgentClassloaderAdditionalLibs() {
        return StringUtils.tokenizeToStringList((String)this.agentClassloaderAdditionalLibs, (String)",");
    }

    @Override
    public String readString(String propertyName, String defaultValue) {
        return this.readString(propertyName, defaultValue, BypassResolver.RESOLVER);
    }

    @Override
    public String readString(String propertyName, String defaultValue, ValueResolver valueResolver) {
        Objects.requireNonNull(valueResolver, "valueResolver");
        String value = this.properties.getProperty(propertyName, defaultValue);
        value = valueResolver.resolve(propertyName, value);
        if (logger.isDebugEnabled()) {
            logger.debug(propertyName + "=" + value);
        }
        return value;
    }

    @Override
    public int readInt(String propertyName, int defaultValue) {
        String value = this.properties.getProperty(propertyName);
        int result = NumberUtils.parseInteger(value, defaultValue);
        if (logger.isDebugEnabled()) {
            logger.debug(propertyName + "=" + result);
        }
        return result;
    }

    @Override
    public DumpType readDumpType(String propertyName, DumpType defaultDump) {
        DumpType result;
        String propertyValue = this.properties.getProperty(propertyName);
        if (propertyValue == null) {
            propertyValue = defaultDump.name();
        }
        String value = propertyValue.toUpperCase();
        try {
            result = DumpType.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            result = defaultDump;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(propertyName + "=" + (Object)((Object)result));
        }
        return result;
    }

    @Override
    public long readLong(String propertyName, long defaultValue) {
        String value = this.properties.getProperty(propertyName);
        long result = NumberUtils.parseLong(value, defaultValue);
        if (logger.isDebugEnabled()) {
            logger.debug(propertyName + "=" + result);
        }
        return result;
    }

    @Override
    public List<String> readList(String propertyName) {
        String value = this.properties.getProperty(propertyName);
        if (StringUtils.isEmpty((String)value)) {
            return Collections.emptyList();
        }
        return StringUtils.tokenizeToStringList((String)value, (String)",");
    }

    @Override
    public boolean readBoolean(String propertyName, boolean defaultValue) {
        String value = this.properties.getProperty(propertyName, Boolean.toString(defaultValue));
        boolean result = Boolean.parseBoolean(value);
        if (logger.isDebugEnabled()) {
            logger.debug(propertyName + "=" + result);
        }
        return result;
    }

    @Override
    public Map<String, String> readPattern(String propertyNamePatternRegex) {
        Pattern pattern = Pattern.compile(propertyNamePatternRegex);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key;
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !pattern.matcher(key = (String)entry.getKey()).matches()) continue;
            String value = (String)entry.getValue();
            result.put(key, value);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(propertyNamePatternRegex + "=" + result);
        }
        return result;
    }

    public String toString() {
        return "DefaultProfilerConfig{pinpointDisable='" + this.pinpointDisable + '\'' + ", activeProfile=" + this.activeProfile + ", logDirMaxBackupSize=" + this.logDirMaxBackupSize + ", staticResourceCleanup=" + this.staticResourceCleanup + ", jdbcSqlCacheSize=" + this.jdbcSqlCacheSize + ", traceSqlBindValue=" + this.traceSqlBindValue + ", maxSqlBindValueSize=" + this.maxSqlBindValueSize + ", httpStatusCodeErrors=" + this.httpStatusCodeErrors + ", injectionModuleFactoryClazzName='" + this.injectionModuleFactoryClazzName + '\'' + ", applicationNamespace='" + this.applicationNamespace + '\'' + '}';
    }
}

