/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor;

import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AbstractSpanEventInterceptorForPlugin;
import com.navercorp.pinpoint.bootstrap.interceptor.ApiIdAwareAroundInterceptor;

public abstract class SpanEventApiIdAwareAroundInterceptorForPlugin
extends AbstractSpanEventInterceptorForPlugin
implements ApiIdAwareAroundInterceptor {
    protected SpanEventApiIdAwareAroundInterceptorForPlugin(TraceContext traceContext) {
        super(traceContext);
    }

    @Override
    public void before(Object target, int apiId, Object[] args) {
        block4: {
            if (this.isDebug) {
                this.logBeforeInterceptor(target, args);
            }
            this.prepareBeforeTrace(target, apiId, args);
            Trace trace = this.currentTrace();
            if (trace == null) {
                return;
            }
            try {
                SpanEventRecorder recorder = trace.traceBlockBegin();
                this.beforeTrace(trace, recorder, target, apiId, args);
                this.doInBeforeTrace(recorder, target, apiId, args);
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block4;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    protected void prepareBeforeTrace(Object target, int apiId, Object[] args) {
    }

    protected void beforeTrace(Trace trace, SpanEventRecorder recorder, Object target, int apiId, Object[] args) {
    }

    protected abstract void doInBeforeTrace(SpanEventRecorder var1, Object var2, int var3, Object[] var4) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(Object target, int apiId, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logAfterInterceptor(target, args, result, throwable);
        }
        this.prepareAfterTrace(target, apiId, args, result, throwable);
        Trace trace = this.currentTrace();
        if (trace == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            this.afterTrace(trace, recorder, target, apiId, args, result, throwable);
            this.doInAfterTrace(recorder, target, apiId, args, result, throwable);
        }
        catch (Throwable th) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("AFTER error. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    protected void prepareAfterTrace(Object target, int apiId, Object[] args, Object result, Throwable throwable) {
    }

    protected void afterTrace(Trace trace, SpanEventRecorder recorder, Object target, int apiId, Object[] args, Object result, Throwable throwable) {
    }

    protected abstract void doInAfterTrace(SpanEventRecorder var1, Object var2, int var3, Object[] var4, Object var5, Throwable var6) throws Exception;
}

