/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request;

import com.navercorp.pinpoint.bootstrap.context.Header;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientHeaderAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceWriter;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.Objects;

public class DefaultRequestTraceWriter<T>
implements RequestTraceWriter<T> {
    private static final String NOT_SET = null;
    private final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final ClientHeaderAdaptor<T> clientHeaderAdaptor;
    private final String applicationName;
    private final short serverTypeCode;
    private final String applicationNamespace;

    public DefaultRequestTraceWriter(ClientHeaderAdaptor<T> clientHeaderAdaptor, TraceContext traceContext) {
        this(clientHeaderAdaptor, traceContext.getApplicationName(), traceContext.getServerTypeCode(), traceContext.getProfilerConfig().getApplicationNamespace());
    }

    public DefaultRequestTraceWriter(ClientHeaderAdaptor<T> clientHeaderAdaptor, String applicationName, short serverTypeCode, String applicationNamespace) {
        this.clientHeaderAdaptor = Objects.requireNonNull(clientHeaderAdaptor, "clientHeaderAdaptor");
        this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
        this.serverTypeCode = serverTypeCode;
        this.applicationNamespace = StringUtils.defaultIfEmpty((String)applicationNamespace, (String)NOT_SET);
    }

    @Override
    public void write(T header) {
        if (this.isDebug) {
            this.logger.debug("Set request header that is not to be sampled.");
        }
        this.clientHeaderAdaptor.setHeader(header, Header.HTTP_SAMPLED.toString(), "s0");
    }

    @Override
    public void write(T header, TraceId traceId, String host) {
        Objects.requireNonNull(traceId, "traceId");
        if (this.isDebug) {
            this.logger.debug("Set request header. traceId={}, applicationName={}, serverTypeCode={}, applicationNamespace={}", traceId, this.applicationName, this.serverTypeCode, this.applicationNamespace);
        }
        this.clientHeaderAdaptor.setHeader(header, Header.HTTP_TRACE_ID.toString(), traceId.getTransactionId());
        this.clientHeaderAdaptor.setHeader(header, Header.HTTP_SPAN_ID.toString(), String.valueOf(traceId.getSpanId()));
        this.clientHeaderAdaptor.setHeader(header, Header.HTTP_PARENT_SPAN_ID.toString(), String.valueOf(traceId.getParentSpanId()));
        this.clientHeaderAdaptor.setHeader(header, Header.HTTP_FLAGS.toString(), String.valueOf(traceId.getFlags()));
        this.clientHeaderAdaptor.setHeader(header, Header.HTTP_PARENT_APPLICATION_NAME.toString(), this.applicationName);
        this.clientHeaderAdaptor.setHeader(header, Header.HTTP_PARENT_APPLICATION_TYPE.toString(), Short.toString(this.serverTypeCode));
        if (this.applicationNamespace != NOT_SET) {
            this.clientHeaderAdaptor.setHeader(header, Header.HTTP_PARENT_APPLICATION_NAMESPACE.toString(), this.applicationNamespace);
        }
        if (host != null) {
            this.clientHeaderAdaptor.setHeader(header, Header.HTTP_HOST.toString(), host);
        }
    }
}

