/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.connector.core.spi;

import com.alibaba.otter.canal.connector.core.spi.SPI;
import com.alibaba.otter.canal.connector.core.spi.URLClassExtensionLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionLoader<T> {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionLoader.class);
    private static final String SERVICES_DIRECTORY = "META-INF/services/";
    private static final String CANAL_DIRECTORY = "META-INF/canal/";
    private static final String DEFAULT_CLASSLOADER_POLICY = "internal";
    private static final Pattern NAME_SEPARATOR = Pattern.compile("\\s*[,]+\\s*");
    private static final ConcurrentMap<Class<?>, ExtensionLoader<?>> EXTENSION_LOADERS = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Object> EXTENSION_INSTANCES = new ConcurrentHashMap();
    private static final ConcurrentMap<String, Object> EXTENSION_KEY_INSTANCE = new ConcurrentHashMap<String, Object>();
    private final Class<?> type;
    private final String classLoaderPolicy;
    private final ConcurrentMap<Class<?>, String> cachedNames = new ConcurrentHashMap();
    private final Holder<Map<String, Class<?>>> cachedClasses = new Holder();
    private final ConcurrentMap<String, Holder<Object>> cachedInstances = new ConcurrentHashMap<String, Holder<Object>>();
    private String cachedDefaultName;
    private ConcurrentHashMap<String, IllegalStateException> exceptions = new ConcurrentHashMap();

    private static <T> boolean withExtensionAnnotation(Class<T> type) {
        return type.isAnnotationPresent(SPI.class);
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> type) {
        return ExtensionLoader.getExtensionLoader(type, DEFAULT_CLASSLOADER_POLICY);
    }

    public static <T> ExtensionLoader<T> getExtensionLoader(Class<T> type, String classLoaderPolicy) {
        if (type == null) {
            throw new IllegalArgumentException("Extension type == null");
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException("Extension type(" + type + ") is not interface!");
        }
        if (!ExtensionLoader.withExtensionAnnotation(type)) {
            throw new IllegalArgumentException("Extension type(" + type + ") is not extension, because WITHOUT @" + SPI.class.getSimpleName() + " Annotation!");
        }
        ExtensionLoader loader = (ExtensionLoader)EXTENSION_LOADERS.get(type);
        if (loader == null) {
            EXTENSION_LOADERS.putIfAbsent(type, new ExtensionLoader<T>(type, classLoaderPolicy));
            loader = (ExtensionLoader)EXTENSION_LOADERS.get(type);
        }
        return loader;
    }

    public ExtensionLoader(Class<?> type) {
        this.type = type;
        this.classLoaderPolicy = DEFAULT_CLASSLOADER_POLICY;
    }

    public ExtensionLoader(Class<?> type, String classLoaderPolicy) {
        this.type = type;
        this.classLoaderPolicy = classLoaderPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getExtension(String name, String spiDir, String standbyDir) {
        Object instance;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Extension name == null");
        }
        if ("true".equals(name)) {
            return this.getDefaultExtension(spiDir, standbyDir);
        }
        Holder holder = (Holder)this.cachedInstances.get(name);
        if (holder == null) {
            this.cachedInstances.putIfAbsent(name, new Holder());
            holder = (Holder)this.cachedInstances.get(name);
        }
        if ((instance = holder.get()) == null) {
            Holder holder2 = holder;
            synchronized (holder2) {
                instance = holder.get();
                if (instance == null) {
                    instance = this.createExtension(name, spiDir, standbyDir);
                    holder.set(instance);
                }
            }
        }
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getExtension(String name, String key, String spiDir, String standbyDir) {
        Object instance;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Extension name == null");
        }
        if ("true".equals(name)) {
            return this.getDefaultExtension(spiDir, standbyDir);
        }
        String extKey = name + "-" + StringUtils.trimToEmpty((String)key);
        Holder holder = (Holder)this.cachedInstances.get(extKey);
        if (holder == null) {
            this.cachedInstances.putIfAbsent(extKey, new Holder());
            holder = (Holder)this.cachedInstances.get(extKey);
        }
        if ((instance = holder.get()) == null) {
            Holder holder2 = holder;
            synchronized (holder2) {
                instance = holder.get();
                if (instance == null) {
                    instance = this.createExtension(name, key, spiDir, standbyDir);
                    holder.set(instance);
                }
            }
        }
        return (T)instance;
    }

    public T getDefaultExtension(String spiDir, String standbyDir) {
        this.getExtensionClasses(spiDir, standbyDir);
        if (null == this.cachedDefaultName || this.cachedDefaultName.length() == 0 || "true".equals(this.cachedDefaultName)) {
            return null;
        }
        return this.getExtension(this.cachedDefaultName, spiDir, standbyDir);
    }

    public T createExtension(String name, String spiDir, String standbyDir) {
        Class<?> clazz = this.getExtensionClasses(spiDir, standbyDir).get(name);
        if (clazz == null) {
            throw new IllegalStateException("Extension instance(name: " + name + ", class: " + this.type + ")  could not be instantiated: class could not be found");
        }
        try {
            Object instance = EXTENSION_INSTANCES.get(clazz);
            if (instance == null) {
                EXTENSION_INSTANCES.putIfAbsent(clazz, clazz.newInstance());
                instance = EXTENSION_INSTANCES.get(clazz);
            }
            return (T)instance;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Extension instance(name: " + name + ", class: " + this.type + ")  could not be instantiated: " + t.getMessage(), t);
        }
    }

    private T createExtension(String name, String key, String spiDir, String standbyDir) {
        Class<?> clazz = this.getExtensionClasses(spiDir, standbyDir).get(name);
        if (clazz == null) {
            throw new IllegalStateException("Extension instance(name: " + name + ", class: " + this.type + ")  could not be instantiated: class could not be found");
        }
        try {
            Object instance = EXTENSION_KEY_INSTANCE.get(name + "-" + key);
            if (instance == null) {
                EXTENSION_KEY_INSTANCE.putIfAbsent(name + "-" + key, clazz.newInstance());
                instance = EXTENSION_KEY_INSTANCE.get(name + "-" + key);
            }
            return (T)instance;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Extension instance(name: " + name + ", class: " + this.type + ")  could not be instantiated: " + t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Class<?>> getExtensionClasses(String spiDir, String standbyDir) {
        Map<String, Class<?>> classes = (Map<String, Class<?>>)((Holder)this.cachedClasses).get();
        if (classes == null) {
            Holder<Map<String, Class<?>>> holder = this.cachedClasses;
            synchronized (holder) {
                classes = (Map)((Holder)this.cachedClasses).get();
                if (classes == null) {
                    classes = this.loadExtensionClasses(spiDir, standbyDir);
                    ((Holder)this.cachedClasses).set(classes);
                }
            }
        }
        return classes;
    }

    private String getJarDirectoryPath() {
        Path path;
        String dirtyPath;
        URL url = Thread.currentThread().getContextClassLoader().getResource("");
        if (url != null) {
            dirtyPath = url.toString();
        } else {
            File file = new File("");
            dirtyPath = file.getAbsolutePath();
        }
        String jarPath = dirtyPath.replaceAll("^.*file:/", "");
        jarPath = jarPath.replaceAll("jar!.*", "jar");
        jarPath = jarPath.replaceAll("%20", " ");
        if (!jarPath.endsWith(".jar")) {
            jarPath = jarPath.replaceAll("/classes/.*", "/classes/");
        }
        if ((path = Paths.get(jarPath, new String[0]).getParent()) != null) {
            return path.toString();
        }
        return null;
    }

    private Map<String, Class<?>> loadExtensionClasses(String spiDir, String standbyDir) {
        SPI defaultAnnotation = this.type.getAnnotation(SPI.class);
        if (defaultAnnotation != null) {
            String value = defaultAnnotation.value();
            if ((value = value.trim()).length() > 0) {
                Object[] names = NAME_SEPARATOR.split(value);
                if (names.length > 1) {
                    throw new IllegalStateException("more than 1 default extension name on extension " + this.type.getName() + ": " + Arrays.toString(names));
                }
                if (names.length == 1) {
                    this.cachedDefaultName = names[0];
                }
            }
        }
        HashMap extensionClasses = new HashMap();
        if (spiDir != null && standbyDir != null) {
            File[] files;
            String dir = File.separator + this.getJarDirectoryPath() + spiDir;
            File externalLibDir = new File(dir);
            if (!externalLibDir.exists()) {
                externalLibDir = new File(File.separator + this.getJarDirectoryPath() + standbyDir);
            }
            logger.info("extension classpath dir: " + externalLibDir.getAbsolutePath());
            if (externalLibDir.exists() && (files = externalLibDir.listFiles((dir1, name) -> name.endsWith(".jar"))) != null) {
                for (File f : files) {
                    URL url;
                    try {
                        url = f.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException("load extension jar failed!", e);
                    }
                    ClassLoader parent = Thread.currentThread().getContextClassLoader();
                    URLClassLoader localClassLoader = this.classLoaderPolicy == null || "".equals(this.classLoaderPolicy) || DEFAULT_CLASSLOADER_POLICY.equalsIgnoreCase(this.classLoaderPolicy) ? new URLClassExtensionLoader(new URL[]{url}) : new URLClassLoader(new URL[]{url}, parent);
                    this.loadFile(extensionClasses, CANAL_DIRECTORY, localClassLoader);
                    this.loadFile(extensionClasses, SERVICES_DIRECTORY, localClassLoader);
                }
            }
        }
        ClassLoader classLoader = ExtensionLoader.findClassLoader();
        this.loadFile(extensionClasses, CANAL_DIRECTORY, classLoader);
        this.loadFile(extensionClasses, SERVICES_DIRECTORY, classLoader);
        return extensionClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(Map<String, Class<?>> extensionClasses, String dir, ClassLoader classLoader) {
        block19: {
            String fileName = dir + this.type.getName();
            try {
                Enumeration<URL> urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
                if (urls == null) break block19;
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    try {
                        BufferedReader reader = null;
                        try {
                            reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                            String line = null;
                            while ((line = reader.readLine()) != null) {
                                int ci = line.indexOf(35);
                                if (ci >= 0) {
                                    line = line.substring(0, ci);
                                }
                                if ((line = line.trim()).length() <= 0) continue;
                                try {
                                    String name = null;
                                    int i = line.indexOf(61);
                                    if (i > 0) {
                                        name = line.substring(0, i).trim();
                                        line = line.substring(i + 1).trim();
                                    }
                                    if (line.length() <= 0) continue;
                                    Class<?> clazz = classLoader.loadClass(line);
                                    if (!this.type.isAssignableFrom(clazz)) {
                                        throw new IllegalStateException("Error when load extension class(interface: " + this.type + ", class line: " + clazz.getName() + "), class " + clazz.getName() + "is not subtype of interface.");
                                    }
                                    try {
                                        clazz.getConstructor(this.type);
                                    }
                                    catch (NoSuchMethodException e) {
                                        clazz.getConstructor(new Class[0]);
                                        String[] names = NAME_SEPARATOR.split(name);
                                        if (names == null || names.length <= 0) continue;
                                        for (String n : names) {
                                            Class<?> c;
                                            if (!this.cachedNames.containsKey(clazz)) {
                                                this.cachedNames.put(clazz, n);
                                            }
                                            if ((c = extensionClasses.get(n)) == null) {
                                                extensionClasses.put(n, clazz);
                                                continue;
                                            }
                                            if (c == clazz) continue;
                                            this.cachedNames.remove(clazz);
                                            throw new IllegalStateException("Duplicate extension " + this.type.getName() + " name " + n + " on " + c.getName() + " and " + clazz.getName());
                                        }
                                    }
                                }
                                catch (Throwable t) {
                                    IllegalStateException e = new IllegalStateException("Failed to load extension class(interface: " + this.type + ", class line: " + line + ") in " + url + ", cause: " + t.getMessage(), t);
                                    this.exceptions.put(line, e);
                                }
                            }
                        }
                        finally {
                            if (reader == null) continue;
                            reader.close();
                        }
                    }
                    catch (Throwable t) {
                        logger.error("Exception when load extension class(interface: " + this.type + ", class file: " + url + ") in " + url, t);
                    }
                }
            }
            catch (Throwable t) {
                logger.error("Exception when load extension class(interface: " + this.type + ", description file: " + fileName + ").", t);
            }
        }
    }

    private static ClassLoader findClassLoader() {
        return ExtensionLoader.class.getClassLoader();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.type.getName() + "]";
    }

    private static class Holder<T> {
        private volatile T value;

        private Holder() {
        }

        private void set(T value) {
            this.value = value;
        }

        private T get() {
            return this.value;
        }
    }
}

