/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.meta;

import com.alibaba.otter.canal.meta.CanalMetaManager;
import com.alibaba.otter.canal.meta.MemoryMetaManager;
import com.alibaba.otter.canal.meta.ZooKeeperMetaManager;
import com.alibaba.otter.canal.meta.exception.CanalMetaManagerException;
import com.alibaba.otter.canal.protocol.ClientIdentity;
import com.alibaba.otter.canal.protocol.position.Position;
import com.alibaba.otter.canal.protocol.position.PositionRange;
import com.google.common.collect.MigrateMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.util.Assert;

public class MixedMetaManager
extends MemoryMetaManager
implements CanalMetaManager {
    private ExecutorService executor;
    private ZooKeeperMetaManager zooKeeperMetaManager;
    private final Position nullCursor = new Position(){};

    @Override
    public void start() {
        super.start();
        Assert.notNull((Object)this.zooKeeperMetaManager);
        if (!this.zooKeeperMetaManager.isStart()) {
            this.zooKeeperMetaManager.start();
        }
        this.executor = Executors.newFixedThreadPool(1);
        this.destinations = MigrateMap.makeComputingMap(destination -> this.zooKeeperMetaManager.listAllSubscribeInfo((String)destination));
        this.cursors = MigrateMap.makeComputingMap(clientIdentity -> {
            Position position = this.zooKeeperMetaManager.getCursor((ClientIdentity)clientIdentity);
            if (position == null) {
                return this.nullCursor;
            }
            return position;
        });
        this.batches = MigrateMap.makeComputingMap(clientIdentity -> {
            MemoryMetaManager.MemoryClientIdentityBatch batches = MemoryMetaManager.MemoryClientIdentityBatch.create(clientIdentity);
            Map<Long, PositionRange> positionRanges = this.zooKeeperMetaManager.listAllBatchs((ClientIdentity)clientIdentity);
            for (Map.Entry<Long, PositionRange> entry : positionRanges.entrySet()) {
                batches.addPositionRange(entry.getValue(), entry.getKey());
            }
            return batches;
        });
    }

    @Override
    public void stop() {
        super.stop();
        if (this.zooKeeperMetaManager.isStart()) {
            this.zooKeeperMetaManager.stop();
        }
        this.executor.shutdownNow();
        this.destinations.clear();
        this.batches.clear();
    }

    @Override
    public void subscribe(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        super.subscribe(clientIdentity);
        this.executor.submit(() -> this.zooKeeperMetaManager.subscribe(clientIdentity));
    }

    @Override
    public void unsubscribe(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        super.unsubscribe(clientIdentity);
        this.executor.submit(() -> this.zooKeeperMetaManager.unsubscribe(clientIdentity));
    }

    @Override
    public void updateCursor(ClientIdentity clientIdentity, Position position) throws CanalMetaManagerException {
        super.updateCursor(clientIdentity, position);
        this.executor.submit(() -> this.zooKeeperMetaManager.updateCursor(clientIdentity, position));
    }

    @Override
    public Position getCursor(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        Position position = super.getCursor(clientIdentity);
        if (position == this.nullCursor) {
            return null;
        }
        return position;
    }

    @Override
    public Long addBatch(ClientIdentity clientIdentity, PositionRange positionRange) throws CanalMetaManagerException {
        Long batchId = super.addBatch(clientIdentity, positionRange);
        this.executor.submit(() -> this.zooKeeperMetaManager.addBatch(clientIdentity, positionRange, batchId));
        return batchId;
    }

    @Override
    public void addBatch(ClientIdentity clientIdentity, PositionRange positionRange, Long batchId) throws CanalMetaManagerException {
        super.addBatch(clientIdentity, positionRange, batchId);
        this.executor.submit(() -> this.zooKeeperMetaManager.addBatch(clientIdentity, positionRange, batchId));
    }

    @Override
    public PositionRange removeBatch(ClientIdentity clientIdentity, Long batchId) throws CanalMetaManagerException {
        PositionRange positionRange = super.removeBatch(clientIdentity, batchId);
        this.executor.submit(() -> this.zooKeeperMetaManager.removeBatch(clientIdentity, batchId));
        return positionRange;
    }

    @Override
    public void clearAllBatchs(ClientIdentity clientIdentity) throws CanalMetaManagerException {
        super.clearAllBatchs(clientIdentity);
        this.executor.submit(() -> this.zooKeeperMetaManager.clearAllBatchs(clientIdentity));
    }

    public void setZooKeeperMetaManager(ZooKeeperMetaManager zooKeeperMetaManager) {
        this.zooKeeperMetaManager = zooKeeperMetaManager;
    }
}

