/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.lark.sink.connector;

import com.github.rholder.retry.RetryException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.lark.oapi.Client;
import com.lark.oapi.core.enums.AppType;
import com.lark.oapi.core.request.SelfBuiltTenantAccessTokenReq;
import com.lark.oapi.core.response.TenantAccessTokenResp;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.lark.LarkSinkConfig;
import org.apache.eventmesh.common.config.connector.lark.SinkConnectorConfig;
import org.apache.eventmesh.connector.lark.ConfigUtils;
import org.apache.eventmesh.connector.lark.sink.ImServiceHandler;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LarkSinkConnector
implements Sink {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LarkSinkConnector.class);
    public static final String TENANT_ACCESS_TOKEN = "tenant_access_token";
    public static final Cache<String, String> AUTH_CACHE = CacheBuilder.newBuilder().initialCapacity(12).maximumSize(10L).concurrencyLevel(5).expireAfterWrite(30L, TimeUnit.MINUTES).build();
    private LarkSinkConfig sinkConfig;
    private ImServiceHandler imServiceHandler;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public Class<? extends Config> configClass() {
        return LarkSinkConfig.class;
    }

    public void init(Config config) {
    }

    public void init(ConnectorContext connectorContext) {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.sinkConfig = (LarkSinkConfig)sinkConnectorContext.getSinkConfig();
        SinkConnectorConfig sinkConnectorConfig = this.sinkConfig.getSinkConnectorConfig();
        ConfigUtils.validateSinkConfiguration(sinkConnectorConfig);
        this.imServiceHandler = ImServiceHandler.create(sinkConnectorConfig);
    }

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            log.info("LarkSinkConnector has been started.");
        }
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getSinkConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() {
        if (!this.started.compareAndSet(true, false)) {
            log.info("LarkSinkConnector has not started yet.");
        }
    }

    public void put(List<ConnectRecord> sinkRecords) {
        for (ConnectRecord connectRecord : sinkRecords) {
            try {
                if (Boolean.parseBoolean(this.sinkConfig.getSinkConnectorConfig().getSinkAsync())) {
                    this.imServiceHandler.sinkAsync(connectRecord);
                    continue;
                }
                this.imServiceHandler.sink(connectRecord);
            }
            catch (RetryException | ExecutionException e) {
                log.error("Failed to sink event to lark", e);
            }
        }
    }

    public static String getTenantAccessToken(String appId, String appSecret) {
        return (String)AUTH_CACHE.get((Object)TENANT_ACCESS_TOKEN, () -> {
            Client client = Client.newBuilder((String)appId, (String)appSecret).appType(AppType.SELF_BUILT).logReqAtDebug(true).build();
            TenantAccessTokenResp resp = client.ext().getTenantAccessTokenBySelfBuiltApp(SelfBuiltTenantAccessTokenReq.newBuilder().appSecret(appSecret).appId(appId).build());
            return resp.getTenantAccessToken();
        });
    }
}

