/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.runtime.admin.handler.HttpHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.ConfigurationHandlerV1;
import org.apache.eventmesh.runtime.admin.handler.v1.DeleteWebHookConfigHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.EventHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.GrpcClientHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.HTTPClientHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.InsertWebHookConfigHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.MetaHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.QueryRecommendEventMeshHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.QueryWebHookConfigByIdHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.QueryWebHookConfigByManufacturerHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.RedirectClientByIpPortHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.RedirectClientByPathHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.RedirectClientBySubSystemHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.RejectAllClientHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.RejectClientByIpPortHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.RejectClientBySubSystemHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.ShowClientBySystemHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.ShowClientHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.ShowListenClientByTopicHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.TCPClientHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.TopicHandler;
import org.apache.eventmesh.runtime.admin.handler.v1.UpdateWebHookConfigHandler;
import org.apache.eventmesh.runtime.admin.handler.v2.ConfigurationHandler;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.meta.MetaStorage;
import org.apache.eventmesh.webhook.admin.AdminWebHookConfigOperationManager;
import org.apache.eventmesh.webhook.api.WebHookConfigOperation;

public class AdminHandlerManager {
    private EventMeshServer eventMeshServer;
    private EventMeshTCPServer eventMeshTCPServer;
    private EventMeshHTTPServer eventMeshHTTPServer;
    private EventMeshGrpcServer eventMeshGrpcServer;
    private MetaStorage eventMeshMetaStorage;
    private AdminWebHookConfigOperationManager adminWebHookConfigOperationManage;
    private final Map<String, HttpHandler> httpHandlerMap = new ConcurrentHashMap<String, HttpHandler>();

    public AdminHandlerManager(EventMeshServer eventMeshServer) {
        this.eventMeshServer = eventMeshServer;
        this.eventMeshTCPServer = eventMeshServer.getEventMeshTCPServer();
        this.eventMeshGrpcServer = eventMeshServer.getEventMeshGrpcServer();
        this.eventMeshHTTPServer = eventMeshServer.getEventMeshHTTPServer();
        this.eventMeshMetaStorage = eventMeshServer.getMetaStorage();
        this.adminWebHookConfigOperationManage = this.eventMeshTCPServer.getAdminWebHookConfigOperationManage();
    }

    public void registerHttpHandler() {
        this.initHandler(new ShowClientHandler(this.eventMeshTCPServer));
        this.initHandler(new ShowClientBySystemHandler(this.eventMeshTCPServer));
        this.initHandler(new RejectAllClientHandler(this.eventMeshTCPServer));
        this.initHandler(new RejectClientByIpPortHandler(this.eventMeshTCPServer));
        this.initHandler(new RejectClientBySubSystemHandler(this.eventMeshTCPServer));
        this.initHandler(new RedirectClientBySubSystemHandler(this.eventMeshTCPServer));
        this.initHandler(new RedirectClientByPathHandler(this.eventMeshTCPServer));
        this.initHandler(new RedirectClientByIpPortHandler(this.eventMeshTCPServer));
        this.initHandler(new ShowListenClientByTopicHandler(this.eventMeshTCPServer));
        this.initHandler(new QueryRecommendEventMeshHandler(this.eventMeshTCPServer));
        this.initHandler(new TCPClientHandler(this.eventMeshTCPServer));
        this.initHandler(new HTTPClientHandler(this.eventMeshHTTPServer));
        this.initHandler(new GrpcClientHandler(this.eventMeshGrpcServer));
        this.initHandler(new ConfigurationHandlerV1(this.eventMeshTCPServer.getEventMeshTCPConfiguration(), this.eventMeshHTTPServer.getEventMeshHttpConfiguration(), this.eventMeshGrpcServer.getEventMeshGrpcConfiguration()));
        this.initHandler(new TopicHandler(this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshStoragePluginType()));
        this.initHandler(new EventHandler(this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshStoragePluginType()));
        this.initHandler(new MetaHandler(this.eventMeshMetaStorage));
        if (Objects.nonNull(this.adminWebHookConfigOperationManage.getWebHookConfigOperation())) {
            WebHookConfigOperation webHookConfigOperation = this.adminWebHookConfigOperationManage.getWebHookConfigOperation();
            this.initHandler(new InsertWebHookConfigHandler(webHookConfigOperation));
            this.initHandler(new UpdateWebHookConfigHandler(webHookConfigOperation));
            this.initHandler(new DeleteWebHookConfigHandler(webHookConfigOperation));
            this.initHandler(new QueryWebHookConfigByIdHandler(webHookConfigOperation));
            this.initHandler(new QueryWebHookConfigByManufacturerHandler(webHookConfigOperation));
        }
        this.initHandler(new ConfigurationHandler(this.eventMeshServer.getConfiguration(), this.eventMeshTCPServer.getEventMeshTCPConfiguration(), this.eventMeshHTTPServer.getEventMeshHttpConfiguration(), this.eventMeshGrpcServer.getEventMeshGrpcConfiguration()));
    }

    private void initHandler(HttpHandler httpHandler) {
        EventMeshHttpHandler eventMeshHttpHandler = httpHandler.getClass().getAnnotation(EventMeshHttpHandler.class);
        this.httpHandlerMap.putIfAbsent(eventMeshHttpHandler.path(), httpHandler);
    }

    public Optional<HttpHandler> getHttpHandler(String path) {
        return Optional.ofNullable(this.httpHandlerMap.get(path));
    }
}

