/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler.v1;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.admin.request.DeleteGrpcClientRequest;
import org.apache.eventmesh.runtime.admin.response.v1.GetClientResponse;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.ConsumerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.util.HttpRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshHttpHandler(path="/client/grpc")
public class GrpcClientHandler
extends AbstractHttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrpcClientHandler.class);
    private final EventMeshGrpcServer eventMeshGrpcServer;

    public GrpcClientHandler(EventMeshGrpcServer eventMeshGrpcServer) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
    }

    @Override
    protected void delete(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        Map<String, Object> body = HttpRequestUtil.parseHttpRequestBody(httpRequest);
        Objects.requireNonNull(body, "body can not be null");
        DeleteGrpcClientRequest deleteGrpcClientRequest = (DeleteGrpcClientRequest)JsonUtils.mapToObject(body, DeleteGrpcClientRequest.class);
        String url = Objects.requireNonNull(deleteGrpcClientRequest).getUrl();
        ConsumerManager consumerManager = this.eventMeshGrpcServer.getConsumerManager();
        Map<String, List<ConsumerGroupClient>> clientTable = consumerManager.getClientTable();
        for (List<ConsumerGroupClient> clientList : clientTable.values()) {
            for (ConsumerGroupClient client : clientList) {
                if (!Objects.equals(client.getUrl(), url)) continue;
                consumerManager.deregisterClient(client);
            }
        }
        this.writeText(ctx, "");
    }

    @Override
    protected void get(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        ArrayList<GetClientResponse> getClientResponseList = new ArrayList<GetClientResponse>();
        ConsumerManager consumerManager = this.eventMeshGrpcServer.getConsumerManager();
        Map<String, List<ConsumerGroupClient>> clientTable = consumerManager.getClientTable();
        for (List<ConsumerGroupClient> clientList : clientTable.values()) {
            for (ConsumerGroupClient client : clientList) {
                GetClientResponse getClientResponse = new GetClientResponse(Optional.ofNullable(client.env).orElse(""), Optional.ofNullable(client.sys).orElse(""), Optional.ofNullable(client.url).orElse(""), "0", Optional.ofNullable(client.hostname).orElse(""), 0, Optional.ofNullable(client.apiVersion).orElse(""), Optional.ofNullable(client.idc).orElse(""), Optional.ofNullable(client.consumerGroup).orElse(""), "", "gRPC");
                getClientResponseList.add(getClientResponse);
            }
        }
        getClientResponseList.sort((lhs, rhs) -> {
            if (lhs.getHost().equals(rhs.getHost())) {
                return lhs.getHost().compareTo(rhs.getHost());
            }
            return Integer.compare(rhs.getPort(), lhs.getPort());
        });
        String result = JsonUtils.toJSONString(getClientResponseList);
        this.writeJson(ctx, result);
    }
}

