/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler.v1;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.util.HttpRequestUtil;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.api.WebHookConfigOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshHttpHandler(path="/webhook/queryWebHookConfigByManufacturer")
public class QueryWebHookConfigByManufacturerHandler
extends AbstractHttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryWebHookConfigByManufacturerHandler.class);
    private final transient WebHookConfigOperation operation;

    public QueryWebHookConfigByManufacturerHandler(WebHookConfigOperation operation) {
        this.operation = operation;
        Objects.requireNonNull(operation, "WebHookConfigOperation can not be null");
    }

    @Override
    public void handle(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        Map<String, Object> body = HttpRequestUtil.parseHttpRequestBody(httpRequest);
        Objects.requireNonNull(body, "body can not be null");
        WebHookConfig webHookConfig = (WebHookConfig)JsonUtils.mapToObject(body, WebHookConfig.class);
        Integer pageNum = Integer.valueOf(body.get("pageNum").toString());
        Integer pageSize = Integer.valueOf(body.get("pageSize").toString());
        List listWebHookConfig = this.operation.queryWebHookConfigByManufacturer(webHookConfig, pageNum, pageSize);
        String result = JsonUtils.toJSONString((Object)listWebHookConfig);
        this.writeJson(ctx, result);
    }
}

