/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler.v1;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshHttpHandler(path="/clientManage/showClientBySystem")
public class ShowClientBySystemHandler
extends AbstractHttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShowClientBySystemHandler.class);
    private final EventMeshTCPServer eventMeshTCPServer;

    public ShowClientBySystemHandler(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public void handle(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        StringBuilder result = new StringBuilder();
        String queryString = URI.create(httpRequest.uri()).getQuery();
        Map queryStringInfo = NetUtils.formData2Dic((String)queryString);
        String subSystem = (String)queryStringInfo.get("subsystem");
        String newLine = System.getProperty("line.separator");
        log.info("showClientBySubsys,subsys:{}", (Object)subSystem);
        ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
        ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
        if (sessionMap != null && !sessionMap.isEmpty()) {
            for (Session session : sessionMap.values()) {
                if (!session.getClient().getSubsystem().equals(subSystem)) continue;
                UserAgent userAgent = session.getClient();
                result.append(String.format("pid=%s | ip=%s | port=%s | path=%s | purpose=%s", userAgent.getPid(), userAgent.getHost(), userAgent.getPort(), userAgent.getPath(), userAgent.getPurpose())).append(newLine);
            }
        }
        this.writeText(ctx, result.toString());
    }
}

