/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.opentelemetry.api.trace.Span;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolKey;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.utils.AssertUtils;
import org.apache.eventmesh.runtime.boot.AbstractRemotingServer;
import org.apache.eventmesh.runtime.boot.HTTPThreadPoolGroup;
import org.apache.eventmesh.runtime.boot.SSLContextFactory;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HandlerService;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.metrics.http.EventMeshHttpMetricsManager;
import org.apache.eventmesh.runtime.util.HttpRequestUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.TraceUtils;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHTTPServer
extends AbstractRemotingServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractHTTPServer.class);
    private final transient EventMeshHTTPConfiguration eventMeshHttpConfiguration;
    private EventMeshHttpMetricsManager eventMeshHttpMetricsManager;
    private static final DefaultHttpDataFactory DEFAULT_HTTP_DATA_FACTORY = new DefaultHttpDataFactory(false);
    protected final transient AtomicBoolean started = new AtomicBoolean(false);
    private final transient boolean useTLS;
    private Boolean useTrace = false;
    private static final int MAX_CONNECTIONS = 20000;
    protected final transient Map<String, HttpRequestProcessor> httpRequestProcessorTable = new ConcurrentHashMap<String, HttpRequestProcessor>(64);
    private HttpConnectionHandler httpConnectionHandler;
    private HttpDispatcher httpDispatcher;
    private HandlerService handlerService;
    private final transient ThreadPoolExecutor asyncContextCompleteHandler = ThreadPoolFactory.createThreadPoolExecutor((int)10, (int)10, (String)"EventMesh-http-asyncContext");
    private final HTTPThreadPoolGroup httpThreadPoolGroup;

    public AbstractHTTPServer(int port, boolean useTLS, EventMeshHTTPConfiguration eventMeshHttpConfiguration) {
        this.setPort(port);
        this.useTLS = useTLS;
        this.eventMeshHttpConfiguration = eventMeshHttpConfiguration;
        this.httpThreadPoolGroup = new HTTPThreadPoolGroup(eventMeshHttpConfiguration);
    }

    protected void initSharableHandlers() {
        this.httpConnectionHandler = new HttpConnectionHandler();
        this.httpDispatcher = new HttpDispatcher();
    }

    @Override
    public void init() throws Exception {
        super.init("eventMesh-http");
        this.initProducerManager();
        this.httpThreadPoolGroup.initThreadPool();
    }

    @Override
    public CommonConfiguration getConfiguration() {
        return this.eventMeshHttpConfiguration;
    }

    @Override
    public void start() throws Exception {
        this.initSharableHandlers();
        Thread thread = new Thread(() -> {
            ServerBootstrap bootstrap = new ServerBootstrap();
            try {
                ((ServerBootstrap)bootstrap.group(this.getBossGroup(), this.getIoGroup()).channel(this.useEpoll() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).childHandler((ChannelHandler)new HttpsServerInitializer(this.useTLS ? SSLContextFactory.getSslContext(this.eventMeshHttpConfiguration) : null)).childOption(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE);
                log.info("HTTPServer[port={}] started.", (Object)this.getPort());
                bootstrap.bind(this.getPort()).channel().closeFuture().sync();
            }
            catch (Exception e) {
                log.error("HTTPServer start error!", (Throwable)e);
                try {
                    this.shutdown();
                }
                catch (Exception ex) {
                    log.error("HTTPServer shutdown error!", (Throwable)ex);
                }
                System.exit(-1);
            }
        }, "EventMesh-http-server");
        thread.setDaemon(true);
        thread.start();
        this.started.compareAndSet(false, true);
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
        this.httpThreadPoolGroup.shutdownThreadPool();
        this.started.compareAndSet(true, false);
    }

    public void registerProcessor(Integer requestCode, HttpRequestProcessor processor) {
        AssertUtils.notNull((Object)requestCode, (String)"requestCode can't be null");
        AssertUtils.notNull((Object)processor, (String)"processor can't be null");
        this.httpRequestProcessorTable.putIfAbsent(requestCode.toString(), processor);
    }

    private HttpResponseStatus validateHttpRequest(HttpRequest httpRequest) {
        if (!this.started.get()) {
            return HttpResponseStatus.SERVICE_UNAVAILABLE;
        }
        if (!httpRequest.decoderResult().isSuccess()) {
            return HttpResponseStatus.BAD_REQUEST;
        }
        if (!HttpMethod.GET.equals((Object)httpRequest.method()) && !HttpMethod.POST.equals((Object)httpRequest.method())) {
            return HttpResponseStatus.METHOD_NOT_ALLOWED;
        }
        if (!ProtocolVersion.contains((String)httpRequest.headers().get("version"))) {
            return HttpResponseStatus.BAD_REQUEST;
        }
        return null;
    }

    public void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        HttpHeaders responseHeaders = response.headers();
        responseHeaders.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)String.format("text/plain; charset=%s", EventMeshConstants.DEFAULT_CHARSET));
        responseHeaders.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        responseHeaders.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void sendResponse(ChannelHandlerContext ctx, DefaultFullHttpResponse response) {
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (!f.isSuccess()) {
                log.warn("send response to [{}] fail, will close this channel", (Object)RemotingHelper.parseChannelRemoteAddr(f.channel()));
                f.channel().close();
            }
        }));
    }

    private Map<String, Object> parseHttpRequestBody(HttpRequest httpRequest) throws IOException {
        return HttpRequestUtil.parseHttpRequestBody(httpRequest, () -> System.currentTimeMillis(), startTime -> this.eventMeshHttpMetricsManager.getHttpMetrics().recordDecodeTimeCost(System.currentTimeMillis() - startTime));
    }

    @Generated
    public EventMeshHttpMetricsManager getEventMeshHttpMetricsManager() {
        return this.eventMeshHttpMetricsManager;
    }

    @Generated
    public void setEventMeshHttpMetricsManager(EventMeshHttpMetricsManager eventMeshHttpMetricsManager) {
        this.eventMeshHttpMetricsManager = eventMeshHttpMetricsManager;
    }

    @Generated
    public boolean isUseTLS() {
        return this.useTLS;
    }

    @Generated
    public Boolean getUseTrace() {
        return this.useTrace;
    }

    @Generated
    public void setUseTrace(Boolean useTrace) {
        this.useTrace = useTrace;
    }

    @Generated
    public void setHandlerService(HandlerService handlerService) {
        this.handlerService = handlerService;
    }

    @Generated
    public HandlerService getHandlerService() {
        return this.handlerService;
    }

    @Generated
    public HTTPThreadPoolGroup getHttpThreadPoolGroup() {
        return this.httpThreadPoolGroup;
    }

    static {
        DiskAttribute.deleteOnExitTemporaryFile = false;
    }

    private class HttpsServerInitializer
    extends ChannelInitializer<SocketChannel> {
        private final transient SSLContext sslContext;

        public HttpsServerInitializer(SSLContext sslContext) {
            this.sslContext = sslContext;
        }

        protected void initChannel(SocketChannel channel) {
            ChannelPipeline pipeline = channel.pipeline();
            if (this.sslContext != null && AbstractHTTPServer.this.useTLS) {
                SSLEngine sslEngine = this.sslContext.createSSLEngine();
                sslEngine.setUseClientMode(false);
                pipeline.addFirst(AbstractHTTPServer.this.getWorkerGroup(), "ssl", (ChannelHandler)new SslHandler(sslEngine));
            }
            pipeline.addLast(AbstractHTTPServer.this.getWorkerGroup(), new ChannelHandler[]{new HttpRequestDecoder(), new HttpResponseEncoder(), AbstractHTTPServer.this.httpConnectionHandler, new HttpObjectAggregator(Integer.MAX_VALUE), AbstractHTTPServer.this.httpDispatcher});
        }
    }

    @ChannelHandler.Sharable
    protected class HttpConnectionHandler
    extends ChannelDuplexHandler {
        public final transient AtomicInteger connections = new AtomicInteger(0);

        protected HttpConnectionHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            if (this.connections.incrementAndGet() > 20000) {
                log.warn("client|http|channelActive|remoteAddress={}|msg=too many client({}) connect this eventMesh server", (Object)RemotingHelper.parseChannelRemoteAddr(ctx.channel()), (Object)20000);
                ctx.close();
                return;
            }
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.connections.decrementAndGet();
            super.channelInactive(ctx);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            IdleStateEvent event;
            if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                log.info("client|http|userEventTriggered|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)evt.getClass().getName());
                ctx.close();
            }
            ctx.fireUserEventTriggered(evt);
        }
    }

    @ChannelHandler.Sharable
    private class HttpDispatcher
    extends ChannelInboundHandlerAdapter {
        private HttpDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (!(msg instanceof HttpRequest)) {
                return;
            }
            HttpRequest httpRequest = (HttpRequest)msg;
            if (Objects.nonNull(AbstractHTTPServer.this.handlerService) && AbstractHTTPServer.this.handlerService.isProcessorWrapper(httpRequest)) {
                AbstractHTTPServer.this.handlerService.handler(ctx, httpRequest, AbstractHTTPServer.this.asyncContextCompleteHandler);
                return;
            }
            try {
                Span span = null;
                this.injectHttpRequestHeader(ctx, httpRequest);
                Map<String, Object> headerMap = Utils.parseHttpHeader(httpRequest);
                HttpResponseStatus errorStatus = AbstractHTTPServer.this.validateHttpRequest(httpRequest);
                if (errorStatus != null) {
                    AbstractHTTPServer.this.sendError(ctx, errorStatus);
                    span = TraceUtils.prepareServerSpan(headerMap, "upstream-eventmesh-server-span", false);
                    TraceUtils.finishSpanWithException(span, headerMap, errorStatus.reasonPhrase(), null);
                    return;
                }
                AbstractHTTPServer.this.eventMeshHttpMetricsManager.getHttpMetrics().recordHTTPRequest();
                HttpCommand requestCommand = new HttpCommand();
                Map bodyMap = AbstractHTTPServer.this.parseHttpRequestBody(httpRequest);
                String requestCode = HttpMethod.POST.equals((Object)httpRequest.method()) ? httpRequest.headers().get("code") : MapUtils.getString((Map)bodyMap, (Object)StringUtils.lowerCase((String)"code"), (String)"");
                requestCommand.setHttpMethod(httpRequest.method().name());
                requestCommand.setHttpVersion(httpRequest.protocolVersion() == null ? "" : httpRequest.protocolVersion().protocolName());
                requestCommand.setRequestCode(requestCode);
                HttpCommand responseCommand = null;
                if (StringUtils.isBlank((CharSequence)requestCode) || !AbstractHTTPServer.this.httpRequestProcessorTable.containsKey(requestCode) || !RequestCode.contains((Integer)Integer.valueOf(requestCode))) {
                    responseCommand = requestCommand.createHttpCommandResponse(EventMeshRetCode.EVENTMESH_REQUESTCODE_INVALID);
                    AbstractHTTPServer.this.sendResponse(ctx, responseCommand.httpResponse(HttpResponseStatus.BAD_REQUEST));
                    span = TraceUtils.prepareServerSpan(headerMap, "upstream-eventmesh-server-span", false);
                    TraceUtils.finishSpanWithException(span, headerMap, EventMeshRetCode.EVENTMESH_REQUESTCODE_INVALID.getErrMsg(), null);
                    return;
                }
                try {
                    requestCommand.setHeader(Header.buildHeader((String)requestCode, headerMap));
                    requestCommand.setBody(Body.buildBody((String)requestCode, (Map)bodyMap));
                }
                catch (Exception e) {
                    responseCommand = requestCommand.createHttpCommandResponse(EventMeshRetCode.EVENTMESH_RUNTIME_ERR);
                    AbstractHTTPServer.this.sendResponse(ctx, responseCommand.httpResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR));
                    span = TraceUtils.prepareServerSpan(headerMap, "upstream-eventmesh-server-span", false);
                    TraceUtils.finishSpanWithException(span, headerMap, EventMeshRetCode.EVENTMESH_RUNTIME_ERR.getErrMsg(), (Throwable)e);
                    ReferenceCountUtil.release((Object)httpRequest);
                    return;
                }
                log.debug("{}", (Object)requestCommand);
                AsyncContext<HttpCommand> asyncContext = new AsyncContext<HttpCommand>(requestCommand, responseCommand, AbstractHTTPServer.this.asyncContextCompleteHandler);
                this.processHttpCommandRequest(ctx, asyncContext);
            }
            catch (Exception ex) {
                log.error("AbstractHTTPServer.HTTPHandler.channelRead error", (Throwable)ex);
                AbstractHTTPServer.this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
            finally {
                ReferenceCountUtil.release((Object)httpRequest);
            }
        }

        private void injectHttpRequestHeader(ChannelHandlerContext ctx, HttpRequest httpRequest) {
            long startTime = System.currentTimeMillis();
            HttpHeaders requestHeaders = httpRequest.headers();
            requestHeaders.set("reqc2eventmeshtimestamp", (Object)startTime);
            if (StringUtils.isBlank((CharSequence)requestHeaders.get("version"))) {
                requestHeaders.set("version", (Object)ProtocolVersion.V1.getVersion());
            }
            requestHeaders.set(ProtocolKey.ClientInstanceKey.IP.getKey(), (Object)RemotingHelper.parseChannelRemoteAddr(ctx.channel()));
            requestHeaders.set("reqsendeventmeship", (Object)AbstractHTTPServer.this.eventMeshHttpConfiguration.getEventMeshServerIp());
        }

        private void processHttpCommandRequest(ChannelHandlerContext ctx, AsyncContext<HttpCommand> asyncContext) {
            HttpCommand request = asyncContext.getRequest();
            HttpRequestProcessor choosed = AbstractHTTPServer.this.httpRequestProcessorTable.get(request.getRequestCode());
            Runnable runnable = () -> {
                try {
                    HttpRequestProcessor processor = choosed;
                    if (processor.rejectRequest()) {
                        HttpCommand responseCommand = request.createHttpCommandResponse(EventMeshRetCode.EVENTMESH_REJECT_BY_PROCESSOR_ERROR);
                        asyncContext.onComplete(responseCommand);
                        if (asyncContext.isComplete()) {
                            AbstractHTTPServer.this.sendResponse(ctx, responseCommand.httpResponse());
                            log.debug("{}", asyncContext.getResponse());
                            Map traceMap = ((HttpCommand)asyncContext.getRequest()).getHeader().toMap();
                            TraceUtils.finishSpanWithException(TraceUtils.prepareServerSpan(traceMap, "upstream-eventmesh-server-span", false), traceMap, EventMeshRetCode.EVENTMESH_REJECT_BY_PROCESSOR_ERROR.getErrMsg(), null);
                        }
                        return;
                    }
                    processor.processRequest(ctx, asyncContext);
                    if (!asyncContext.isComplete()) {
                        return;
                    }
                    log.debug("{}", asyncContext.getResponse());
                    AbstractHTTPServer.this.eventMeshHttpMetricsManager.getHttpMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - request.getReqTime());
                    AbstractHTTPServer.this.sendResponse(ctx, ((HttpCommand)asyncContext.getResponse()).httpResponse());
                }
                catch (Exception e) {
                    log.error("process error", (Throwable)e);
                }
            };
            try {
                if (Objects.nonNull(choosed.executor())) {
                    choosed.executor().execute(() -> runnable.run());
                } else {
                    runnable.run();
                }
            }
            catch (RejectedExecutionException re) {
                asyncContext.onComplete(request.createHttpCommandResponse(EventMeshRetCode.OVERLOAD));
                AbstractHTTPServer.this.eventMeshHttpMetricsManager.getHttpMetrics().recordHTTPDiscard();
                AbstractHTTPServer.this.eventMeshHttpMetricsManager.getHttpMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - request.getReqTime());
                try {
                    AbstractHTTPServer.this.sendResponse(ctx, asyncContext.getResponse().httpResponse());
                    Map traceMap = asyncContext.getRequest().getHeader().toMap();
                    TraceUtils.finishSpanWithException(TraceUtils.prepareServerSpan(traceMap, "upstream-eventmesh-server-span", false), traceMap, EventMeshRetCode.EVENTMESH_RUNTIME_ERR.getErrMsg(), (Throwable)re);
                }
                catch (Exception e) {
                    log.error("processEventMeshRequest fail", (Throwable)re);
                }
            }
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            super.channelReadComplete(ctx);
            ctx.flush();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (cause != null) {
                log.error("", cause);
            }
            if (ctx != null) {
                ctx.close();
            }
        }
    }
}

