/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import java.io.File;
import lombok.Generated;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.apache.eventmesh.runtime.constants.EventMeshConstants;
import org.apache.eventmesh.runtime.util.BannerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshStartup {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventMeshStartup.class);

    public static void main(String[] args) throws Exception {
        try {
            ConfigService.getInstance().setConfigPath(EventMeshConstants.EVENTMESH_CONF_HOME + File.separator).setRootConfig("eventmesh.properties");
            EventMeshServer server = new EventMeshServer();
            BannerUtil.generateBanner();
            server.init();
            server.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    log.info("eventMesh shutting down hook begin.");
                    long start = System.currentTimeMillis();
                    server.shutdown();
                    long end = System.currentTimeMillis();
                    log.info("eventMesh shutdown cost {}ms", (Object)(end - start));
                }
                catch (Exception e) {
                    log.error("exception when shutdown.", (Throwable)e);
                }
            }));
        }
        catch (Throwable e) {
            log.error("EventMesh start fail.", e);
            System.exit(-1);
        }
    }
}

