/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.api.meta.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.meta.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.apache.eventmesh.metrics.api.MetricsPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.AbstractTCPServer;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.apache.eventmesh.runtime.configuration.EventMeshTCPConfiguration;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.GoodbyeProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.HeartBeatProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.HelloProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.ListenProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.MessageAckProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.MessageTransferProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.RecommendProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.SubscribeProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.UnSubscribeProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.rebalance.EventMeshRebalanceImpl;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.rebalance.EventMeshRebalanceService;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.retry.TcpRetryer;
import org.apache.eventmesh.runtime.meta.MetaStorage;
import org.apache.eventmesh.runtime.metrics.tcp.EventMeshTcpMetricsManager;
import org.apache.eventmesh.webhook.admin.AdminWebHookConfigOperationManager;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshTCPServer
extends AbstractTCPServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventMeshTCPServer.class);
    private final EventMeshServer eventMeshServer;
    private final EventMeshTCPConfiguration eventMeshTCPConfiguration;
    private final MetaStorage metaStorage;
    private final Acl acl;
    private ClientSessionGroupMapping clientSessionGroupMapping;
    private TcpRetryer tcpRetryer;
    private AdminWebHookConfigOperationManager adminWebHookConfigOperationManage;
    private RateLimiter rateLimiter;
    private EventMeshRebalanceService eventMeshRebalanceService;

    public EventMeshTCPServer(EventMeshServer eventMeshServer, EventMeshTCPConfiguration eventMeshTCPConfiguration) {
        super(eventMeshTCPConfiguration);
        this.eventMeshServer = eventMeshServer;
        this.eventMeshTCPConfiguration = eventMeshTCPConfiguration;
        this.metaStorage = eventMeshServer.getMetaStorage();
        this.acl = eventMeshServer.getAcl();
    }

    @Override
    public void init() throws Exception {
        log.info("==================EventMeshTCPServer Initialing==================");
        super.init();
        this.rateLimiter = RateLimiter.create((double)this.eventMeshTCPConfiguration.getEventMeshTcpMsgReqnumPerSecond().intValue());
        ArrayList metricsRegistries = Lists.newArrayList();
        Optional.ofNullable(this.eventMeshTCPConfiguration.getEventMeshMetricsPluginType()).ifPresent(metricsPlugins -> metricsPlugins.forEach(pluginType -> metricsRegistries.add(MetricsPluginFactory.getMetricsRegistry((String)pluginType))));
        this.tcpRetryer = new TcpRetryer(this);
        this.clientSessionGroupMapping = new ClientSessionGroupMapping(this);
        this.clientSessionGroupMapping.init();
        super.setClientSessionGroupMapping(this.clientSessionGroupMapping);
        super.setEventMeshTcpMetricsManager(new EventMeshTcpMetricsManager(this, metricsRegistries));
        if (this.eventMeshTCPConfiguration.isEventMeshServerMetaStorageEnable()) {
            this.eventMeshRebalanceService = new EventMeshRebalanceService(this, new EventMeshRebalanceImpl(this));
            this.eventMeshRebalanceService.init();
        }
        this.adminWebHookConfigOperationManage = new AdminWebHookConfigOperationManager();
        this.adminWebHookConfigOperationManage.init();
        this.registerTCPRequestProcessor();
        log.info("--------------------------EventMeshTCPServer Inited");
    }

    @Override
    public void start() throws Exception {
        super.start();
        super.getEventMeshTcpMetricsManager().start();
        this.clientSessionGroupMapping.start();
        this.tcpRetryer.start();
        if (this.eventMeshTCPConfiguration.isEventMeshServerMetaStorageEnable()) {
            this.register();
            this.eventMeshRebalanceService.start();
        }
        log.info("--------------------------EventMeshTCPServer Started");
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
        super.getEventMeshTcpMetricsManager().shutdown();
        this.clientSessionGroupMapping.shutdown();
        ThreadUtils.sleep((long)40L, (TimeUnit)TimeUnit.SECONDS);
        this.tcpRetryer.shutdown();
        if (this.eventMeshTCPConfiguration.isEventMeshServerMetaStorageEnable()) {
            this.eventMeshRebalanceService.shutdown();
            this.unRegister();
        }
        log.info("--------------------------EventMeshTCPServer Shutdown");
    }

    public boolean register() {
        boolean registerResult = false;
        try {
            String endPoints = IPUtils.getLocalAddress() + ":" + this.eventMeshTCPConfiguration.getEventMeshTcpServerPort();
            EventMeshRegisterInfo eventMeshRegisterInfo = new EventMeshRegisterInfo();
            eventMeshRegisterInfo.setEventMeshClusterName(this.eventMeshTCPConfiguration.getEventMeshCluster());
            eventMeshRegisterInfo.setEventMeshName(this.eventMeshTCPConfiguration.getEventMeshName() + "-" + "TCP");
            eventMeshRegisterInfo.setEndPoint(endPoints);
            eventMeshRegisterInfo.setEventMeshInstanceNumMap(this.clientSessionGroupMapping.prepareProxyClientDistributionData());
            eventMeshRegisterInfo.setProtocolType("TCP");
            registerResult = this.metaStorage.register(eventMeshRegisterInfo);
        }
        catch (Exception e) {
            log.error("eventMesh register to registry failed", (Throwable)e);
        }
        return registerResult;
    }

    private void unRegister() {
        String endPoints = IPUtils.getLocalAddress() + ":" + this.eventMeshTCPConfiguration.getEventMeshTcpServerPort();
        EventMeshUnRegisterInfo eventMeshUnRegisterInfo = new EventMeshUnRegisterInfo();
        eventMeshUnRegisterInfo.setEventMeshClusterName(this.eventMeshTCPConfiguration.getEventMeshCluster());
        eventMeshUnRegisterInfo.setEventMeshName(this.eventMeshTCPConfiguration.getEventMeshName());
        eventMeshUnRegisterInfo.setEndPoint(endPoints);
        eventMeshUnRegisterInfo.setProtocolType("TCP");
        boolean registerResult = this.metaStorage.unRegister(eventMeshUnRegisterInfo);
        if (!registerResult) {
            throw new EventMeshException("eventMesh fail to unRegister");
        }
    }

    private void registerTCPRequestProcessor() {
        ThreadPoolExecutor taskHandleExecutorService = super.getTcpThreadPoolGroup().getTaskHandleExecutorService();
        HelloProcessor helloProcessor = new HelloProcessor(this);
        this.registerProcessor(Command.HELLO_REQUEST, helloProcessor, taskHandleExecutorService);
        RecommendProcessor recommendProcessor = new RecommendProcessor(this);
        this.registerProcessor(Command.RECOMMEND_REQUEST, recommendProcessor, taskHandleExecutorService);
        HeartBeatProcessor heartBeatProcessor = new HeartBeatProcessor(this);
        this.registerProcessor(Command.HEARTBEAT_REQUEST, heartBeatProcessor, taskHandleExecutorService);
        GoodbyeProcessor goodbyeProcessor = new GoodbyeProcessor(this);
        this.registerProcessor(Command.CLIENT_GOODBYE_REQUEST, goodbyeProcessor, taskHandleExecutorService);
        this.registerProcessor(Command.SERVER_GOODBYE_RESPONSE, goodbyeProcessor, taskHandleExecutorService);
        SubscribeProcessor subscribeProcessor = new SubscribeProcessor(this);
        this.registerProcessor(Command.SUBSCRIBE_REQUEST, subscribeProcessor, taskHandleExecutorService);
        UnSubscribeProcessor unSubscribeProcessor = new UnSubscribeProcessor(this);
        this.registerProcessor(Command.UNSUBSCRIBE_REQUEST, unSubscribeProcessor, taskHandleExecutorService);
        ListenProcessor listenProcessor = new ListenProcessor(this);
        this.registerProcessor(Command.LISTEN_REQUEST, listenProcessor, taskHandleExecutorService);
        ThreadPoolExecutor sendExecutorService = super.getTcpThreadPoolGroup().getSendExecutorService();
        MessageTransferProcessor messageTransferProcessor = new MessageTransferProcessor(this);
        this.registerProcessor(Command.REQUEST_TO_SERVER, messageTransferProcessor, sendExecutorService);
        this.registerProcessor(Command.ASYNC_MESSAGE_TO_SERVER, messageTransferProcessor, sendExecutorService);
        this.registerProcessor(Command.BROADCAST_MESSAGE_TO_SERVER, messageTransferProcessor, sendExecutorService);
        ThreadPoolExecutor replyExecutorService = super.getTcpThreadPoolGroup().getReplyExecutorService();
        this.registerProcessor(Command.RESPONSE_TO_SERVER, messageTransferProcessor, replyExecutorService);
        ThreadPoolExecutor ackExecutorService = super.getTcpThreadPoolGroup().getAckExecutorService();
        MessageAckProcessor messageAckProcessor = new MessageAckProcessor(this);
        this.registerProcessor(Command.RESPONSE_TO_CLIENT_ACK, messageAckProcessor, ackExecutorService);
        this.registerProcessor(Command.ASYNC_MESSAGE_TO_CLIENT_ACK, messageAckProcessor, ackExecutorService);
        this.registerProcessor(Command.BROADCAST_MESSAGE_TO_CLIENT_ACK, messageAckProcessor, ackExecutorService);
        this.registerProcessor(Command.REQUEST_TO_CLIENT_ACK, messageAckProcessor, ackExecutorService);
    }

    public EventMeshServer getEventMeshServer() {
        return this.eventMeshServer;
    }

    public EventMeshTCPConfiguration getEventMeshTCPConfiguration() {
        return this.eventMeshTCPConfiguration;
    }

    public MetaStorage getMetaStorage() {
        return this.metaStorage;
    }

    public EventMeshRebalanceService getEventMeshRebalanceService() {
        return this.eventMeshRebalanceService;
    }

    public AdminWebHookConfigOperationManager getAdminWebHookConfigOperationManage() {
        return this.adminWebHookConfigOperationManage;
    }

    public void setAdminWebHookConfigOperationManage(AdminWebHookConfigOperationManager adminWebHookConfigOperationManage) {
        this.adminWebHookConfigOperationManage = adminWebHookConfigOperationManage;
    }

    public Acl getAcl() {
        return this.acl;
    }

    @Override
    public ClientSessionGroupMapping getClientSessionGroupMapping() {
        return this.clientSessionGroupMapping;
    }

    @Override
    public void setClientSessionGroupMapping(ClientSessionGroupMapping clientSessionGroupMapping) {
        this.clientSessionGroupMapping = clientSessionGroupMapping;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public TcpRetryer getTcpRetryer() {
        return this.tcpRetryer;
    }
}

