/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.processor;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.AclException;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.CloudEvent;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventUtils;
import org.apache.eventmesh.common.protocol.grpc.common.EventMeshCloudEventWrapper;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.apache.eventmesh.runtime.core.protocol.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.producer.ProducerManager;
import org.apache.eventmesh.runtime.core.protocol.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplyMessageProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReplyMessageProcessor.class);
    private static final Logger ACL_LOGGER = LoggerFactory.getLogger((String)"acl");
    private final EventMeshGrpcServer eventMeshGrpcServer;
    private final Acl acl;

    public ReplyMessageProcessor(EventMeshGrpcServer eventMeshGrpcServer) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
        this.acl = eventMeshGrpcServer.getAcl();
    }

    public void process(CloudEvent message, final EventEmitter<CloudEvent> emitter) throws Exception {
        if (!ServiceUtils.validateCloudEventAttributes(message)) {
            ServiceUtils.sendStreamResponseCompleted(message, StatusCode.EVENTMESH_PROTOCOL_HEADER_ERR, emitter);
            return;
        }
        if (!ServiceUtils.validateCloudEventData(message)) {
            ServiceUtils.sendStreamResponseCompleted(message, StatusCode.EVENTMESH_PROTOCOL_BODY_ERR, emitter);
            return;
        }
        try {
            this.doAclCheck(message);
        }
        catch (Exception e) {
            ACL_LOGGER.warn("CLIENT HAS NO PERMISSION,RequestReplyMessageProcessor reply failed", (Throwable)e);
            ServiceUtils.sendStreamResponseCompleted(message, StatusCode.EVENTMESH_ACL_ERR, e.getMessage(), emitter);
            return;
        }
        if (!this.eventMeshGrpcServer.getMsgRateLimiter().tryAcquire(100L, TimeUnit.MILLISECONDS)) {
            log.error("Send message speed over limit.");
            ServiceUtils.sendStreamResponseCompleted(message, StatusCode.EVENTMESH_SEND_MESSAGE_SPEED_OVER_LIMIT_ERR, emitter);
            return;
        }
        final String seqNum = EventMeshCloudEventUtils.getSeqNum((CloudEvent)message);
        final String uniqueId = EventMeshCloudEventUtils.getUniqueId((CloudEvent)message);
        String producerGroup = EventMeshCloudEventUtils.getProducerGroup((CloudEvent)message);
        String mqCluster = EventMeshCloudEventUtils.getCluster((CloudEvent)message, (String)"defaultCluster");
        final String replyTopic = mqCluster + "-" + "rr-reply-topic";
        final CloudEvent messageReply = CloudEvent.newBuilder((CloudEvent)message).putAttributes("subject", CloudEvent.CloudEventAttributeValue.newBuilder().setCeString(replyTopic).build()).build();
        String protocolType = EventMeshCloudEventUtils.getProtocolType((CloudEvent)messageReply);
        ProtocolAdaptor grpcCommandProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        io.cloudevents.CloudEvent cloudEvent = grpcCommandProtocolAdaptor.toCloudEvent((ProtocolTransportObject)new EventMeshCloudEventWrapper(messageReply));
        ProducerManager producerManager = this.eventMeshGrpcServer.getProducerManager();
        EventMeshProducer eventMeshProducer = producerManager.getEventMeshProducer(producerGroup);
        SendMessageContext sendMessageContext = new SendMessageContext(seqNum, cloudEvent, eventMeshProducer, this.eventMeshGrpcServer);
        this.eventMeshGrpcServer.getEventMeshGrpcMetricsManager().recordSendMsgToQueue();
        final long startTime = System.currentTimeMillis();
        eventMeshProducer.reply(sendMessageContext, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                long endTime = System.currentTimeMillis();
                log.info("message|mq2eventmesh|REPLY|ReplyToServer|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, replyTopic, seqNum, uniqueId});
            }

            public void onException(OnExceptionContext onExceptionContext) {
                ServiceUtils.sendStreamResponseCompleted(messageReply, StatusCode.EVENTMESH_REPLY_MSG_ERR, EventMeshUtil.stackTrace((Throwable)onExceptionContext.getException(), 2), emitter);
                long endTime = System.currentTimeMillis();
                log.error("message|mq2eventmesh|REPLY|ReplyToServer|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, replyTopic, seqNum, uniqueId, onExceptionContext.getException()});
            }
        });
    }

    private void doAclCheck(CloudEvent message) throws AclException {
        if (this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().isEventMeshServerSecurityEnable()) {
            String remoteAdd = EventMeshCloudEventUtils.getIp((CloudEvent)message);
            String user = EventMeshCloudEventUtils.getUserName((CloudEvent)message);
            String pass = EventMeshCloudEventUtils.getPassword((CloudEvent)message);
            String subsystem = EventMeshCloudEventUtils.getSys((CloudEvent)message);
            String topic = EventMeshCloudEventUtils.getSubject((CloudEvent)message);
            this.acl.doAclCheckInHttpSend(remoteAdd, user, pass, subsystem, topic, RequestCode.REPLY_MESSAGE.getRequestCode());
        }
    }
}

