/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolKey;
import org.apache.eventmesh.common.protocol.http.common.RequestURI;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.common.EventMeshTrace;
import org.apache.eventmesh.runtime.core.consumer.ClientInfo;
import org.apache.eventmesh.runtime.core.consumer.SubscriptionManager;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HandlerService;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.AbstractEventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.WebhookUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshTrace
public class LocalSubscribeEventProcessor
extends AbstractEventProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalSubscribeEventProcessor.class);
    private final Acl acl;

    public LocalSubscribeEventProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        super(eventMeshHTTPServer);
        this.acl = eventMeshHTTPServer.getAcl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handler(HandlerService.HandlerSpecific handlerSpecific, HttpRequest httpRequest) throws Exception {
        Channel channel = handlerSpecific.getCtx().channel();
        HttpEventWrapper requestWrapper = handlerSpecific.getAsyncContext().getRequest();
        String localAddress = IPUtils.getLocalAddress();
        String remoteAddr = RemotingHelper.parseChannelRemoteAddr(channel);
        log.info("uri={}|{}|client2eventMesh|from={}|to={}", new Object[]{requestWrapper.getRequestURI(), "http", remoteAddr, localAddress});
        requestWrapper.getHeaderMap().put(ProtocolKey.ClientInstanceKey.IP.getKey(), remoteAddr);
        requestWrapper.buildSysHeaderForClient();
        Map<String, Object> responseHeaderMap = this.builderResponseHeaderMap(requestWrapper);
        Map sysHeaderMap = requestWrapper.getSysHeaderMap();
        HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
        if (this.validateSysHeader(sysHeaderMap)) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        Map requestBodyMap = Optional.ofNullable(JsonUtils.parseTypeReferenceObject((String)new String(requestWrapper.getBody(), Constants.DEFAULT_CHARSET), (TypeReference)new TypeReference<HashMap<String, Object>>(){})).orElseGet(HashMap::new);
        if (this.validatedRequestBodyMap(requestBodyMap)) {
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        String url = requestBodyMap.get("url").toString();
        String consumerGroup = requestBodyMap.get("consumerGroup").toString();
        String topic = JsonUtils.toJSONString(requestBodyMap.get("topic"));
        List subscriptionList = Optional.ofNullable(JsonUtils.parseTypeReferenceObject((String)topic, (TypeReference)new TypeReference<List<SubscriptionItem>>(){})).orElseGet(Collections::emptyList);
        if (this.eventMeshHTTPServer.getEventMeshHttpConfiguration().isEventMeshServerSecurityEnable()) {
            for (SubscriptionItem item : subscriptionList) {
                try {
                    String user = sysHeaderMap.get(ProtocolKey.ClientInstanceKey.USERNAME.getKey()).toString();
                    String pass = sysHeaderMap.get(ProtocolKey.ClientInstanceKey.PASSWD.getKey()).toString();
                    String subsystem = sysHeaderMap.get(ProtocolKey.ClientInstanceKey.SYS.getKey()).toString();
                    this.acl.doAclCheckInHttpReceive(remoteAddr, user, pass, subsystem, item.getTopic(), requestWrapper.getRequestURI());
                }
                catch (Exception e) {
                    log.warn("CLIENT HAS NO PERMISSION,SubscribeProcessor subscribe failed", (Throwable)e);
                    handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_ACL_ERR, responseHeaderMap, responseBodyMap, null);
                    return;
                }
            }
        }
        try {
            if (!IPUtils.isValidDomainOrIp((String)url, this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshIpv4BlackList(), this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshIpv6BlackList())) {
                log.error("subscriber url {} is not valid", (Object)url);
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, responseHeaderMap, responseBodyMap, null);
                return;
            }
        }
        catch (Exception e) {
            log.error("subscriber url {} is not valid", (Object)url, (Object)e);
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        if (!WebhookUtil.obtainDeliveryAgreement(this.eventMeshHTTPServer.getHttpClientPool().getClient(), url, this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshWebhookOrigin())) {
            log.error("subscriber url {} is not allowed by the target system", (Object)url);
            handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, responseHeaderMap, responseBodyMap, null);
            return;
        }
        ConcurrentHashMap<String, List<Client>> concurrentHashMap = this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping();
        synchronized (concurrentHashMap) {
            ClientInfo clientInfo = this.getClientInfo(requestWrapper);
            SubscriptionManager subscriptionManager = this.eventMeshHTTPServer.getSubscriptionManager();
            subscriptionManager.registerClient(clientInfo, consumerGroup, subscriptionList, url);
            subscriptionManager.updateSubscription(clientInfo, consumerGroup, url, subscriptionList);
            long startTime = System.currentTimeMillis();
            try {
                this.eventMeshHTTPServer.getConsumerManager().notifyConsumerManager(consumerGroup, this.eventMeshHTTPServer.getSubscriptionManager().getLocalConsumerGroupMapping().get(consumerGroup));
                responseBodyMap.put("retCode", EventMeshRetCode.SUCCESS.getRetCode());
                responseBodyMap.put("retMsg", EventMeshRetCode.SUCCESS.getErrMsg());
                handlerSpecific.sendResponse(responseHeaderMap, responseBodyMap);
            }
            catch (Exception e) {
                log.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|url={}", new Object[]{System.currentTimeMillis() - startTime, JsonUtils.toJSONString((Object)subscriptionList), url, e});
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_SUBSCRIBE_ERR, responseHeaderMap, responseBodyMap, null);
            }
            this.eventMeshHTTPServer.getSubscriptionManager().updateMetaData();
        }
    }

    @Override
    public String[] paths() {
        return new String[]{RequestURI.SUBSCRIBE_LOCAL.getRequestURI()};
    }

    @Override
    public Executor executor() {
        return this.eventMeshHTTPServer.getHttpThreadPoolGroup().getClientManageExecutor();
    }

    private ClientInfo getClientInfo(HttpEventWrapper requestWrapper) {
        Map requestHeaderMap = requestWrapper.getSysHeaderMap();
        ClientInfo clientInfo = new ClientInfo();
        clientInfo.setEnv(requestHeaderMap.get(ProtocolKey.ClientInstanceKey.ENV.getKey()).toString());
        clientInfo.setIdc(requestHeaderMap.get(ProtocolKey.ClientInstanceKey.IDC.getKey()).toString());
        clientInfo.setSys(requestHeaderMap.get(ProtocolKey.ClientInstanceKey.SYS.getKey()).toString());
        clientInfo.setIp(requestHeaderMap.get(ProtocolKey.ClientInstanceKey.IP.getKey()).toString());
        clientInfo.setPid(requestHeaderMap.get(ProtocolKey.ClientInstanceKey.PID.getKey()).toString());
        return clientInfo;
    }
}

