/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.processor;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.exception.AclException;
import org.apache.eventmesh.api.meta.bo.EventMeshAppSubTopicInfo;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.TcpProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelloProcessor
implements TcpProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HelloProcessor.class);
    private static final Logger MESSAGE_LOGGER = LoggerFactory.getLogger((String)"message");
    private EventMeshTCPServer eventMeshTCPServer;
    private final Acl acl;

    public HelloProcessor(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.acl = eventMeshTCPServer.getAcl();
    }

    @Override
    public void process(Package pkg, ChannelHandlerContext ctx, long startTime) {
        long taskExecuteTime = System.currentTimeMillis();
        Package res = new Package();
        Session session = null;
        UserAgent user = (UserAgent)pkg.getBody();
        try {
            String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            String group = user.getGroup();
            String token = user.getToken();
            String subsystem = user.getSubsystem();
            if (this.eventMeshTCPServer.getEventMeshTCPConfiguration().isEventMeshServerSecurityEnable()) {
                EventMeshAppSubTopicInfo eventMeshAppSubTopicInfo = this.eventMeshTCPServer.getMetaStorage().findEventMeshAppSubTopicInfo(group);
                if (eventMeshAppSubTopicInfo == null) {
                    throw new AclException("no group register");
                }
                this.acl.doAclCheckInTcpConnect(remoteAddr, token, subsystem, eventMeshAppSubTopicInfo);
            }
            if (this.eventMeshTCPServer.getEventMeshServer().getServiceState() != ServiceState.RUNNING) {
                log.error("server state is not running:{}", (Object)this.eventMeshTCPServer.getEventMeshServer().getServiceState());
                throw new Exception("server state is not running, maybe deploying...");
            }
            this.validateUserAgent(user);
            session = this.eventMeshTCPServer.getClientSessionGroupMapping().createSession(user, ctx);
            res.setHeader(new Header(Command.HELLO_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), pkg.getHeader().getSeq()));
            Utils.writeAndFlush(res, startTime, taskExecuteTime, session.getContext(), session);
        }
        catch (Throwable e) {
            MESSAGE_LOGGER.error("HelloTask failed|address={}", (Object)ctx.channel().remoteAddress(), (Object)e);
            res.setHeader(new Header(Command.HELLO_RESPONSE, OPStatus.FAIL.getCode().intValue(), Arrays.toString(e.getStackTrace()), pkg.getHeader().getSeq()));
            ctx.writeAndFlush((Object)res).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    Utils.logFailedMessageFlow(future, res, user, startTime, taskExecuteTime);
                } else {
                    Utils.logSucceedMessageFlow(res, user, startTime, taskExecuteTime);
                }
                log.warn("HelloTask failed,close session,addr:{}", (Object)ctx.channel().remoteAddress());
                this.eventMeshTCPServer.getClientSessionGroupMapping().closeSession(ctx);
            }));
        }
    }

    private void validateUserAgent(UserAgent user) throws Exception {
        if (user == null) {
            throw new Exception("client info cannot be null");
        }
        if (user.getVersion() == null) {
            throw new Exception("client version cannot be null");
        }
        if (!StringUtils.equalsAny((CharSequence)user.getPurpose(), (CharSequence[])new CharSequence[]{"pub", "sub"})) {
            throw new Exception("client purpose config is error");
        }
        if (StringUtils.isBlank((CharSequence)user.getGroup())) {
            throw new Exception("client group cannot be null");
        }
    }
}

