/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.processor;

import io.netty.channel.ChannelHandlerContext;
import lombok.Generated;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.TcpProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenProcessor
implements TcpProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ListenProcessor.class);
    private EventMeshTCPServer eventMeshTCPServer;
    private final Acl acl;

    public ListenProcessor(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.acl = eventMeshTCPServer.getAcl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Package pkg, ChannelHandlerContext ctx, long startTime) {
        Session session = this.eventMeshTCPServer.getClientSessionGroupMapping().getSession(ctx);
        long taskExecuteTime = System.currentTimeMillis();
        Header header = new Header(Command.LISTEN_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), pkg.getHeader().getSeq());
        session.setListenRequestSeq(pkg.getHeader().getSeq());
        try {
            Session session2 = session;
            synchronized (session2) {
                this.eventMeshTCPServer.getClientSessionGroupMapping().readySession(session);
            }
        }
        catch (Exception e) {
            log.error("ListenTask failed|user={}|errMsg={}", (Object)session.getClient(), (Object)e);
            Integer status = OPStatus.FAIL.getCode();
            header = new Header(Command.LISTEN_RESPONSE, status.intValue(), e.toString(), pkg.getHeader().getSeq());
        }
        finally {
            session.trySendListenResponse(header, startTime, taskExecuteTime);
        }
    }
}

