/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.processor;

import io.netty.channel.ChannelHandlerContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.TcpProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.recommend.EventMeshRecommendImpl;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecommendProcessor
implements TcpProcessor {
    private static final Logger MESSAGE_LOGGER = LoggerFactory.getLogger((String)"message");
    private EventMeshTCPServer eventMeshTCPServer;
    private final Acl acl;

    public RecommendProcessor(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.acl = eventMeshTCPServer.getAcl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Package pkg, ChannelHandlerContext ctx, long startTime) {
        Session session = this.eventMeshTCPServer.getClientSessionGroupMapping().getSession(ctx);
        long taskExecuteTime = System.currentTimeMillis();
        Package res = new Package();
        try {
            if (!this.eventMeshTCPServer.getEventMeshTCPConfiguration().isEventMeshServerMetaStorageEnable()) {
                throw new Exception("registry enable config is false, not support");
            }
            UserAgent user = (UserAgent)pkg.getBody();
            this.validateUserAgent(user);
            String group = this.getGroupOfClient(user);
            EventMeshRecommendImpl eventMeshRecommendStrategy = new EventMeshRecommendImpl(this.eventMeshTCPServer);
            String eventMeshRecommendResult = eventMeshRecommendStrategy.calculateRecommendEventMesh(group, user.getPurpose());
            res.setHeader(new Header(Command.RECOMMEND_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), pkg.getHeader().getSeq()));
            res.setBody((Object)eventMeshRecommendResult);
        }
        catch (Exception e) {
            MESSAGE_LOGGER.error("RecommendTask failed|address={}|errMsg={}", (Object)ctx.channel().remoteAddress(), (Object)e);
            res.setHeader(new Header(Command.RECOMMEND_RESPONSE, OPStatus.FAIL.getCode().intValue(), e.toString(), pkg.getHeader().getSeq()));
        }
        finally {
            Utils.writeAndFlush(res, startTime, taskExecuteTime, session.getContext(), session);
        }
    }

    private void validateUserAgent(UserAgent user) throws Exception {
        if (user == null) {
            throw new Exception("client info cannot be null");
        }
        if (user.getVersion() == null) {
            throw new Exception("client version cannot be null");
        }
        if (user.getUsername() == null) {
            throw new Exception("client wemqUser cannot be null");
        }
        if (user.getPassword() == null) {
            throw new Exception("client wemqPasswd cannot be null");
        }
        if (!StringUtils.equalsAny((CharSequence)user.getPurpose(), (CharSequence[])new CharSequence[]{"pub", "sub"})) {
            throw new Exception("client purpose config is error");
        }
    }

    private String getGroupOfClient(UserAgent userAgent) {
        if (userAgent == null) {
            return null;
        }
        return userAgent.getGroup();
    }
}

