/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.rocketmq.producer;

import io.cloudevents.CloudEvent;
import java.util.Objects;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.api.exception.StorageRuntimeException;
import org.apache.eventmesh.storage.rocketmq.cloudevent.RocketMQMessageFactory;
import org.apache.eventmesh.storage.rocketmq.producer.AbstractProducer;
import org.apache.eventmesh.storage.rocketmq.utils.CloudEventUtils;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.RequestCallback;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageConst;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerImpl
extends AbstractProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProducerImpl.class);
    public static final int eventMeshServerAsyncAccumulationThreshold = 1000;

    public ProducerImpl(Properties properties) {
        super(properties);
    }

    public Properties attributes() {
        return this.properties;
    }

    public void setExtFields() {
        super.getRocketmqProducer().setRetryTimesWhenSendFailed(0);
        super.getRocketmqProducer().setRetryTimesWhenSendAsyncFailed(0);
        super.getRocketmqProducer().setPollNameServerInterval(60000);
        super.getRocketmqProducer().getDefaultMQProducerImpl().getmQClientFactory().getNettyClientConfig().setClientAsyncSemaphoreValue(1000);
        super.getRocketmqProducer().setCompressMsgBodyOverHowmuch(10);
    }

    public SendResult send(CloudEvent cloudEvent) {
        this.checkProducerServiceState(this.rocketmqProducer.getDefaultMQProducerImpl());
        Message msg = (Message)RocketMQMessageFactory.createWriter(Objects.requireNonNull(cloudEvent.getSubject())).writeBinary(cloudEvent);
        this.supplySysProp(msg, cloudEvent);
        String messageId = null;
        try {
            org.apache.rocketmq.client.producer.SendResult sendResultRmq = this.rocketmqProducer.send(msg);
            SendResult sendResult = new SendResult();
            sendResult.setTopic(sendResultRmq.getMessageQueue().getTopic());
            messageId = sendResultRmq.getMsgId();
            sendResult.setMessageId(messageId);
            return sendResult;
        }
        catch (InterruptedException e) {
            log.error("Send message InterruptedException", (Throwable)e);
            Thread.currentThread().interrupt();
            return new SendResult();
        }
        catch (Exception e) {
            log.error(String.format("Send message Exception, %s", msg), (Throwable)e);
            throw this.checkProducerException(msg.getTopic(), messageId, e);
        }
    }

    public void sendOneway(CloudEvent cloudEvent) {
        this.checkProducerServiceState(this.rocketmqProducer.getDefaultMQProducerImpl());
        Message msg = (Message)RocketMQMessageFactory.createWriter(Objects.requireNonNull(cloudEvent.getSubject())).writeBinary(cloudEvent);
        this.supplySysProp(msg, cloudEvent);
        try {
            this.rocketmqProducer.sendOneway(msg);
        }
        catch (InterruptedException e) {
            log.error("Send message oneway InterruptedException", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error(String.format("Send message oneway Exception, %s", msg), (Throwable)e);
            throw this.checkProducerException(msg.getTopic(), MessageClientIDSetter.getUniqID((Message)msg), e);
        }
    }

    public void sendAsync(CloudEvent cloudEvent, org.apache.eventmesh.api.SendCallback sendCallback) {
        this.checkProducerServiceState(this.rocketmqProducer.getDefaultMQProducerImpl());
        Message msg = (Message)RocketMQMessageFactory.createWriter(Objects.requireNonNull(cloudEvent.getSubject())).writeBinary(cloudEvent);
        this.supplySysProp(msg, cloudEvent);
        try {
            this.rocketmqProducer.send(msg, this.sendCallbackConvert(msg, sendCallback));
        }
        catch (InterruptedException e) {
            log.error("Send message async InterruptedException", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error(String.format("Send message async Exception, %s", msg), (Throwable)e);
            throw this.checkProducerException(msg.getTopic(), MessageClientIDSetter.getUniqID((Message)msg), e);
        }
    }

    public void request(CloudEvent cloudEvent, RequestReplyCallback rrCallback, long timeout) throws InterruptedException, RemotingException, MQClientException, MQBrokerException {
        this.checkProducerServiceState(this.rocketmqProducer.getDefaultMQProducerImpl());
        Message msg = (Message)RocketMQMessageFactory.createWriter(Objects.requireNonNull(cloudEvent.getSubject())).writeBinary(cloudEvent);
        this.supplySysProp(msg, cloudEvent);
        this.rocketmqProducer.request(msg, this.rrCallbackConvert(msg, rrCallback), timeout);
    }

    public void reply(CloudEvent cloudEvent, org.apache.eventmesh.api.SendCallback sendCallback) {
        this.checkProducerServiceState(this.rocketmqProducer.getDefaultMQProducerImpl());
        Message msg = (Message)RocketMQMessageFactory.createWriter(Objects.requireNonNull(cloudEvent.getSubject())).writeBinary(cloudEvent);
        MessageAccessor.putProperty((Message)msg, (String)"MSG_TYPE", (String)"reply");
        this.supplySysProp(msg, cloudEvent);
        try {
            this.rocketmqProducer.send(msg, this.sendCallbackConvert(msg, sendCallback));
        }
        catch (InterruptedException e) {
            log.error("Send message async InterruptedException", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error(String.format("Send message async Exception, %s", msg), (Throwable)e);
            throw this.checkProducerException(msg.getTopic(), MessageClientIDSetter.getUniqID((Message)msg), e);
        }
    }

    private Message supplySysProp(Message msg, CloudEvent cloudEvent) {
        for (String sysPropKey : MessageConst.STRING_HASH_SET) {
            String ceKey = sysPropKey.toLowerCase().replace("_", "99");
            if (cloudEvent.getExtension(ceKey) == null || !StringUtils.isNotEmpty((CharSequence)Objects.requireNonNull(cloudEvent.getExtension(ceKey)).toString())) continue;
            MessageAccessor.putProperty((Message)msg, (String)sysPropKey, (String)Objects.requireNonNull(cloudEvent.getExtension(ceKey)).toString());
            msg.getProperties().remove(ceKey);
        }
        return msg;
    }

    private RequestCallback rrCallbackConvert(final Message message, final RequestReplyCallback rrCallback) {
        return new RequestCallback(){

            public void onSuccess(Message message2) {
                for (String sysPropKey : MessageConst.STRING_HASH_SET) {
                    if (!StringUtils.isNotEmpty((CharSequence)message2.getProperty(sysPropKey))) continue;
                    String prop = message2.getProperty(sysPropKey);
                    String tmpPropKey = sysPropKey.toLowerCase().replace("_", "99");
                    MessageAccessor.putProperty((Message)message2, (String)tmpPropKey, (String)prop);
                    message2.getProperties().remove(sysPropKey);
                }
                CloudEvent event = RocketMQMessageFactory.createReader(message2).toEvent();
                rrCallback.onSuccess(event);
            }

            public void onException(Throwable e) {
                String topic = message.getTopic();
                StorageRuntimeException onsEx = ProducerImpl.this.checkProducerException(topic, null, e);
                OnExceptionContext context = new OnExceptionContext();
                context.setTopic(topic);
                context.setException(onsEx);
                rrCallback.onException(e);
            }
        };
    }

    private SendCallback sendCallbackConvert(final Message message, final org.apache.eventmesh.api.SendCallback sendCallback) {
        return new SendCallback(){

            public void onSuccess(org.apache.rocketmq.client.producer.SendResult sendResult) {
                sendCallback.onSuccess(CloudEventUtils.convertSendResult(sendResult));
            }

            public void onException(Throwable e) {
                String topic = message.getTopic();
                StorageRuntimeException onsEx = ProducerImpl.this.checkProducerException(topic, null, e);
                OnExceptionContext context = new OnExceptionContext();
                context.setTopic(topic);
                context.setException(onsEx);
                sendCallback.onException(context);
            }
        };
    }
}

