/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.rabbitmq.client;

import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.storage.rabbitmq.client.RabbitmqConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitmqClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RabbitmqClient.class);
    private final RabbitmqConnectionFactory rabbitmqConnectionFactory;

    public RabbitmqClient(RabbitmqConnectionFactory rabbitmqConnectionFactory) {
        this.rabbitmqConnectionFactory = rabbitmqConnectionFactory;
    }

    public Connection getConnection(String host, String username, String passwd, int port, String virtualHost) throws Exception {
        ConnectionFactory factory = this.rabbitmqConnectionFactory.createConnectionFactory();
        factory.setHost(host.trim());
        factory.setPort(port);
        if (StringUtils.isNotEmpty((CharSequence)virtualHost)) {
            factory.setVirtualHost(virtualHost.trim());
        }
        factory.setUsername(username);
        factory.setPassword(passwd.trim());
        return this.rabbitmqConnectionFactory.createConnection(factory);
    }

    public void publish(Channel channel, String exchangeName, String routingKey, byte[] message) throws Exception {
        channel.basicPublish(exchangeName, routingKey, null, message);
    }

    public void binding(Channel channel, BuiltinExchangeType builtinExchangeType, String exchangeName, String routingKey, String queueName) {
        try {
            channel.exchangeDeclare(exchangeName, builtinExchangeType.getType(), true, false, false, null);
            channel.queueDeclare(queueName, false, false, false, null);
            routingKey = builtinExchangeType.getType().equals(BuiltinExchangeType.FANOUT.getType()) ? "" : routingKey;
            channel.queueBind(queueName, exchangeName, routingKey);
        }
        catch (Exception ex) {
            log.error("[RabbitmqClient] binding happen exception.", (Throwable)ex);
        }
    }

    public void unbinding(Channel channel, String exchangeName, String routingKey, String queueName) {
        try {
            channel.queueUnbind(queueName, exchangeName, routingKey);
        }
        catch (Exception ex) {
            log.error("[RabbitmqClient] unbinding happen exception.", (Throwable)ex);
        }
    }

    public void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception ex) {
                log.error("[RabbitmqClient] connection close happen exception.", (Throwable)ex);
            }
        }
    }

    public void closeChannel(Channel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (Exception ex) {
                log.error("[RabbitmqClient] channel close happen exception.", (Throwable)ex);
            }
        }
    }
}

